#include "VertText.hpp"

#include <iglist.hpp>
#include <ifont.hpp>

VerticalText::VerticalText( IString text,
                 IFont & font,
                 unsigned long windowId,
                 IWindow * parent,
                 IWindow * owner )
  : IDrawingCanvas( windowId, parent, owner, IRectangle() )
{
   setGraphicList( new IGList() );
   IPoint point( font.maxCharHeight(), 0 );
   iText = new IGString( text, point, font );
   iText->rotateBy(  90.0, point );
   graphicList()->addAsLast( *iText );
}


VerticalText::~VerticalText()
{
   delete iText;
}

