/*******************************************************************************
* FILE NAME: VisMidi.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     VisMidi                                                                  *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMENUBAR_
#include <imenubar.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ICNRCOL_
#include <icnrcol.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRMIDI_
#include "IRTMidi.hpp"
#endif

#ifndef _INFO_
#include "Info.hpp"
#endif

#ifndef _KEYBOARD_
#include "Keyboard.hpp"
#endif

#ifndef _PATCHPNL_
#include "PatchPnl.hpp"
#endif

#ifndef _IPROFILE_
#include <iprofile.hpp>
#endif

#ifndef _DUMPER_
#include "Dumper.hpp"
#endif

#ifndef _IVSEQ_H_
#include <ivseq.h>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _VISMIDI_
#include "VisMidi.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for VisMidiConn10
//*****************************************************************************
class VisMidiConn10 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn10(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidi * aSource, IRTMidi * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidi::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to RTMidi(initializePart))");
         try {target->initializePart();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidi * source;
   IRTMidi * target;


};   //VisMidiConn10


//*****************************************************************************
// Class definition for VisMidiConn9
//*****************************************************************************
class VisMidiConn9 : public IObserver {
public:
   virtual  ~VisMidiConn9(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IRTMidi * aSource, IVBContainerControl< IMidiClass*, IVSequence<IMidiClass*>, VisMidiClassContainerCnrObj > * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(classes) to ClassContainer(items))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setItems(source->classes());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IRTMidi::classesId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IVBContainerControl< IMidiClass*, IVSequence<IMidiClass*>, VisMidiClassContainerCnrObj >::itemsId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IRTMidi * source;
   IVBContainerControl< IMidiClass*, IVSequence<IMidiClass*>, VisMidiClassContainerCnrObj > * target;
   Boolean aligning;


};   //VisMidiConn9


//*****************************************************************************
// Class definition for VisMidiConn19
//*****************************************************************************
class VisMidiConn19 : public IObserver {
public:
   virtual  ~VisMidiConn19(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IRTMidi * aSource, IVBContainerControl< IMidiInstance*, IVSequence<IMidiInstance*>, VisMidiInstanceContainerCnrObj > * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(instances) to InstanceContainer(items))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setItems(source->instances());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IRTMidi::instancesId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IVBContainerControl< IMidiInstance*, IVSequence<IMidiInstance*>, VisMidiInstanceContainerCnrObj >::itemsId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IRTMidi * source;
   IVBContainerControl< IMidiInstance*, IVSequence<IMidiInstance*>, VisMidiInstanceContainerCnrObj > * target;
   Boolean aligning;


};   //VisMidiConn19


//*****************************************************************************
// Class definition for VisMidiConn11
//*****************************************************************************
class VisMidiConn11 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   VisMidiConn11(unsigned long tid) {id = tid;};

   virtual  ~VisMidiConn11(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, VisMidiInfoFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == id+WNDOFFSET_VisMidi_prodInfoMenuItem)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : prodInfoMenuItem(commandEvent) to InfoFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   VisMidiInfoFactoryFactory * target;
   unsigned long id;


};   //VisMidiConn11


//*****************************************************************************
// Class definition for VisMidiConn12
//*****************************************************************************
class VisMidiConn12 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn12(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidiInfoFactoryFactory * aSource, IVBVariablePartPointer<Info *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == VisMidiInfoFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : InfoFactory(newEvent) to InfoWindow(this))");
         try {target->setTarget((Info *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidiInfoFactoryFactory * source;
   IVBVariablePartPointer<Info *> * target;


};   //VisMidiConn12


//*****************************************************************************
// Class definition for VisMidiConn25
//*****************************************************************************
class VisMidiConn25 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn25(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidi * aSource, VisMidiKeyboardFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidi::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to KeyboardFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidi * source;
   VisMidiKeyboardFactoryFactory * target;


};   //VisMidiConn25


//*****************************************************************************
// Class definition for VisMidiConn26
//*****************************************************************************
class VisMidiConn26 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn26(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidi * aSource, VisMidiDumperFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidi::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to DumperFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidi * source;
   VisMidiDumperFactoryFactory * target;


};   //VisMidiConn26


//*****************************************************************************
// Class definition for VisMidiConn39
//*****************************************************************************
class VisMidiConn39 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn39(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidi * aSource, VisMidiPatchFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidi::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to PatchFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidi * source;
   VisMidiPatchFactoryFactory * target;


};   //VisMidiConn39


//*****************************************************************************
// Class definition for VisMidiConn65
//*****************************************************************************
class VisMidiConn65 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn65(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IFrameWindow * aSource, VisMidi * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   VisMidiConn65 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::closeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : FrameWindow(closeEvent) to (SaveToProfile))");
         try {target->saveToProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IFrameWindow * source;
   VisMidi * target;
   IProfile * iProfile;


};   //VisMidiConn65


//*****************************************************************************
// Class definition for VisMidiConn44
//*****************************************************************************
class VisMidiConn44 : public IObserver {
public:
   virtual  ~VisMidiConn44(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IRTMidi * aSource, IStaticText * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(RCExplanation) to StaticText3(text))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setText(source->RCExplanation());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IRTMidi::RCExplanationId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IStaticText::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IRTMidi * source;
   IStaticText * target;
   Boolean aligning;


};   //VisMidiConn44


//*****************************************************************************
// Class definition for VisMidiConn35
//*****************************************************************************
class VisMidiConn35 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn35(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IRTMidi * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to RTMidi(resetLastRC))");
         try {target->resetLastRC();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IRTMidi * target;


};   //VisMidiConn35


//*****************************************************************************
// Class definition for VisMidiConn45
//*****************************************************************************
class VisMidiConn45 : public IObserver {
public:
   virtual  ~VisMidiConn45(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IRTMidi * aSource, IStaticText * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(lastRC) to StaticText1(valueAsInt))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->VBSETTEXTFROMVALUE(source->lastRC());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IRTMidi::lastRCId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IStaticText::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IRTMidi * source;
   IStaticText * target;
   Boolean aligning;


};   //VisMidiConn45


//*****************************************************************************
// Class definition for VisMidiConn54
//*****************************************************************************
class VisMidiConn54 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn54(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidi * aSource, VisMidi * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   VisMidiConn54 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidi::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (restoreFromProfile))");
         try {target->restoreFromProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidi * source;
   VisMidi * target;
   IProfile * iProfile;


};   //VisMidiConn54


//*****************************************************************************
// Class definition for VisMidiConn29
//*****************************************************************************
class VisMidiConn29 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   VisMidiConn29(unsigned long tid) {id = tid;};

   virtual  ~VisMidiConn29(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, IVSequence< IFrameWindow * > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == id+WNDOFFSET_VisMidi_exitMenuItem)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : exitMenuItem(commandEvent) to WindowSeq(customLogic, \"Close all windows in list\"))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      IVSequence<IFrameWindow*>::Cursor c(*target);
      forCursor(c)
         c.element()->close();
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   IVSequence< IFrameWindow * > * target;
   unsigned long id;


};   //VisMidiConn29


//*****************************************************************************
// Class definition for VisMidiConn6
//*****************************************************************************
class VisMidiConn6 : public IObserver, public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   VisMidiConn6(unsigned long tid) {id = tid;};

   virtual  ~VisMidiConn6(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMenuBar * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::commandId)
      if (((IEvent *) anEvent.eventData().asUnsignedLong())->parameter1().number1() == id+WNDOFFSET_VisMidi_exitMenuItem)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : exitMenuItem(commandEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMenuBar * source;
   IFrameWindow * target;
   unsigned long id;


};   //VisMidiConn6


//*****************************************************************************
// Class definition for VisMidiConn37
//*****************************************************************************
class VisMidiConn37 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn37(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidiDumperFactoryFactory * aSource, IVSequence< IFrameWindow * > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidiDumperFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : DumperFactory(newEvent) to WindowSeq(addAsLast))");
         try {target->addAsLast((Dumper *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidiDumperFactoryFactory * source;
   IVSequence< IFrameWindow * > * target;


};   //VisMidiConn37


//*****************************************************************************
// Class definition for VisMidiConn28
//*****************************************************************************
class VisMidiConn28 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn28(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidiKeyboardFactoryFactory * aSource, IVSequence< IFrameWindow * > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidiKeyboardFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : KeyboardFactory(newEvent) to WindowSeq(addAsLast))");
         try {target->addAsLast((Keyboard *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidiKeyboardFactoryFactory * source;
   IVSequence< IFrameWindow * > * target;


};   //VisMidiConn28


//*****************************************************************************
// Class definition for VisMidiConn24
//*****************************************************************************
class VisMidiConn24 : public IObserver, public IStandardNotifier {
public:
   virtual  ~VisMidiConn24(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(VisMidiPatchFactoryFactory * aSource, IVSequence< IFrameWindow * > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VisMidiPatchFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PatchFactory(newEvent) to WindowSeq(addAsLast))");
         try {target->addAsLast((PatchPanel *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   VisMidiPatchFactoryFactory * source;
   IVSequence< IFrameWindow * > * target;


};   //VisMidiConn24


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: VisMidiClassContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiClassContainerCnrObj::VisMidiClassContainerCnrObj(IMidiClass&))
VisMidiClassContainerCnrObj::VisMidiClassContainerCnrObj(IMidiClass& anObject)
 :IVBContainerObject(anObject.name(), ISystemPointerHandle(ISystemPointerHandle::warning)),
      inumber(anObject.number()), iname(anObject.name()), inumSlots(anObject.numSlots()), iattributes(anObject.attributes()), pRealObject(anObject)
{
   enableDataUpdate();
   handleNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: VisMidiClassContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiClassContainerCnrObj::VisMidiClassContainerCnrObj(VisMidiClassContainerCnrObj&))
VisMidiClassContainerCnrObj::VisMidiClassContainerCnrObj(VisMidiClassContainerCnrObj& anObject)
 :IVBContainerObject(anObject.iconText(), anObject.icon()),
      inumber(anObject.inumber), iname(anObject.iname), inumSlots(anObject.inumSlots), iattributes(anObject.iattributes), pRealObject(anObject.pRealObject)
{  }


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: ~VisMidiClassContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiClassContainerCnrObj::~VisMidiClassContainerCnrObj())
VisMidiClassContainerCnrObj::~VisMidiClassContainerCnrObj()
{
   this->stopHandlingNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: refreshFromObject
//------------------------------------------------------------------------------
#pragma export (VisMidiClassContainerCnrObj::refreshFromObject())
IVBContainerObject & VisMidiClassContainerCnrObj::refreshFromObject()
{
   setIconText(pRealObject.name());
   setIcon(ISystemPointerHandle(ISystemPointerHandle::warning));
   inumber = pRealObject.number();
   iname = pRealObject.name();
   inumSlots = pRealObject.numSlots();
   iattributes = pRealObject.attributes();
   return *this;
}


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: updateToObject
//------------------------------------------------------------------------------
IVBContainerObject & VisMidiClassContainerCnrObj::updateToObject()
{
   return *this;
}


//------------------------------------------------------------------------------
// VisMidiClassContainerCnrObj :: operator=
//------------------------------------------------------------------------------
VisMidiClassContainerCnrObj& VisMidiClassContainerCnrObj::operator=(const VisMidiClassContainerCnrObj& anObject)
{
   if (this == &anObject) {
      return *this;
      }
   IVBContainerObject::operator=(anObject);
   inumber = anObject.inumber;
   iname = anObject.iname;
   inumSlots = anObject.inumSlots;
   iattributes = anObject.iattributes;
   return *this;
}



//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: VisMidiInstanceContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiInstanceContainerCnrObj::VisMidiInstanceContainerCnrObj(IMidiInstance&))
VisMidiInstanceContainerCnrObj::VisMidiInstanceContainerCnrObj(IMidiInstance& anObject)
 :IVBContainerObject(anObject.name(), ISystemPointerHandle(ISystemPointerHandle::warning)),
      iclassNum(anObject.classNum()), inumLinks(anObject.numLinks()), iattribString(anObject.attribString()), iattributes(anObject.attributes()), pRealObject(anObject)
{
   enableDataUpdate();
   handleNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: VisMidiInstanceContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiInstanceContainerCnrObj::VisMidiInstanceContainerCnrObj(VisMidiInstanceContainerCnrObj&))
VisMidiInstanceContainerCnrObj::VisMidiInstanceContainerCnrObj(VisMidiInstanceContainerCnrObj& anObject)
 :IVBContainerObject(anObject.iconText(), anObject.icon()),
      iclassNum(anObject.iclassNum), inumLinks(anObject.inumLinks), iattribString(anObject.iattribString), iattributes(anObject.iattributes), pRealObject(anObject.pRealObject)
{  }


//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: ~VisMidiInstanceContainerCnrObj
//------------------------------------------------------------------------------
#pragma export (VisMidiInstanceContainerCnrObj::~VisMidiInstanceContainerCnrObj())
VisMidiInstanceContainerCnrObj::~VisMidiInstanceContainerCnrObj()
{
   this->stopHandlingNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: refreshFromObject
//------------------------------------------------------------------------------
#pragma export (VisMidiInstanceContainerCnrObj::refreshFromObject())
IVBContainerObject & VisMidiInstanceContainerCnrObj::refreshFromObject()
{
   setIconText(pRealObject.name());
   setIcon(ISystemPointerHandle(ISystemPointerHandle::warning));
   iclassNum = pRealObject.classNum();
   inumLinks = pRealObject.numLinks();
   iattribString = pRealObject.attribString();
   iattributes = pRealObject.attributes();
   return *this;
}


//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: updateToObject
//------------------------------------------------------------------------------
IVBContainerObject & VisMidiInstanceContainerCnrObj::updateToObject()
{
   return *this;
}


//------------------------------------------------------------------------------
// VisMidiInstanceContainerCnrObj :: operator=
//------------------------------------------------------------------------------
VisMidiInstanceContainerCnrObj& VisMidiInstanceContainerCnrObj::operator=(const VisMidiInstanceContainerCnrObj& anObject)
{
   if (this == &anObject) {
      return *this;
      }
   IVBContainerObject::operator=(anObject);
   iclassNum = anObject.iclassNum;
   inumLinks = anObject.inumLinks;
   iattribString = anObject.iattribString;
   iattributes = anObject.iattributes;
   return *this;
}



const INotificationId VisMidiInfoFactoryFactory::newObjectCreatedId = "VisMidiInfoFactoryFactory::newObjectCreatedId";

#pragma export (VisMidiInfoFactoryFactory::id)
unsigned long VisMidiInfoFactoryFactory::id = 0;

//------------------------------------------------------------------------------
// VisMidiInfoFactoryFactory :: VisMidiInfoFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiInfoFactoryFactory::VisMidiInfoFactoryFactory(unsigned long))
VisMidiInfoFactoryFactory::VisMidiInfoFactoryFactory(unsigned long anId)
{
   enableNotification();
   id = (id) ? id : anId;
}

//------------------------------------------------------------------------------
// VisMidiInfoFactoryFactory :: ~VisMidiInfoFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiInfoFactoryFactory::~VisMidiInfoFactoryFactory())
VisMidiInfoFactoryFactory::~VisMidiInfoFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// VisMidiInfoFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (VisMidiInfoFactoryFactory::create())
Info * VisMidiInfoFactoryFactory::create()
{
   Info *iInfoFactory = new Info(
      id+WNDOFFSET_VisMidi_InfoFactory, 
      IWindow::desktopWindow(), 
      0, 
      Info::defaultFramingSpec());
   iInfoFactory->setAutoDeleteObject(true);
   iInfoFactory->getRTMidi()->setTarget(iRTMidi);
   iInfoFactory->enableNotification();
   iInfoFactory->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iInfoFactory)));
   return(iInfoFactory);
}


const INotificationId VisMidiKeyboardFactoryFactory::newObjectCreatedId = "VisMidiKeyboardFactoryFactory::newObjectCreatedId";

#pragma export (VisMidiKeyboardFactoryFactory::id)
unsigned long VisMidiKeyboardFactoryFactory::id = 0;

//------------------------------------------------------------------------------
// VisMidiKeyboardFactoryFactory :: VisMidiKeyboardFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiKeyboardFactoryFactory::VisMidiKeyboardFactoryFactory(unsigned long))
VisMidiKeyboardFactoryFactory::VisMidiKeyboardFactoryFactory(unsigned long anId)
{
   enableNotification();
   id = (id) ? id : anId;
}

//------------------------------------------------------------------------------
// VisMidiKeyboardFactoryFactory :: ~VisMidiKeyboardFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiKeyboardFactoryFactory::~VisMidiKeyboardFactoryFactory())
VisMidiKeyboardFactoryFactory::~VisMidiKeyboardFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// VisMidiKeyboardFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (VisMidiKeyboardFactoryFactory::create())
Keyboard * VisMidiKeyboardFactoryFactory::create()
{
   Keyboard *iKeyboardFactory = new Keyboard(
      id+WNDOFFSET_VisMidi_KeyboardFactory, 
      IWindow::desktopWindow(), 
      0, 
      Keyboard::defaultFramingSpec());
   iKeyboardFactory->setAutoDeleteObject(true);
   iKeyboardFactory->enableNotification();
   iKeyboardFactory->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iKeyboardFactory)));
   return(iKeyboardFactory);
}

const INotificationId VisMidiPatchFactoryFactory::newObjectCreatedId = "VisMidiPatchFactoryFactory::newObjectCreatedId";

#pragma export (VisMidiPatchFactoryFactory::id)
unsigned long VisMidiPatchFactoryFactory::id = 0;

//------------------------------------------------------------------------------
// VisMidiPatchFactoryFactory :: VisMidiPatchFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiPatchFactoryFactory::VisMidiPatchFactoryFactory(unsigned long))
VisMidiPatchFactoryFactory::VisMidiPatchFactoryFactory(unsigned long anId)
{
   enableNotification();
   id = (id) ? id : anId;
}

//------------------------------------------------------------------------------
// VisMidiPatchFactoryFactory :: ~VisMidiPatchFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiPatchFactoryFactory::~VisMidiPatchFactoryFactory())
VisMidiPatchFactoryFactory::~VisMidiPatchFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// VisMidiPatchFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (VisMidiPatchFactoryFactory::create())
PatchPanel * VisMidiPatchFactoryFactory::create()
{
   PatchPanel *iPatchFactory = new PatchPanel(
      id+WNDOFFSET_VisMidi_PatchFactory, 
      IWindow::desktopWindow(), 
      0, 
      PatchPanel::defaultFramingSpec());
   iPatchFactory->setAutoDeleteObject(true);
   iPatchFactory->getRTMidi()->setTarget(iRTMidi);
   iPatchFactory->enableNotification();
   iPatchFactory->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iPatchFactory)));
   return(iPatchFactory);
}


const INotificationId VisMidiDumperFactoryFactory::newObjectCreatedId = "VisMidiDumperFactoryFactory::newObjectCreatedId";

#pragma export (VisMidiDumperFactoryFactory::id)
unsigned long VisMidiDumperFactoryFactory::id = 0;

//------------------------------------------------------------------------------
// VisMidiDumperFactoryFactory :: VisMidiDumperFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiDumperFactoryFactory::VisMidiDumperFactoryFactory(unsigned long))
VisMidiDumperFactoryFactory::VisMidiDumperFactoryFactory(unsigned long anId)
{
   enableNotification();
   id = (id) ? id : anId;
}

//------------------------------------------------------------------------------
// VisMidiDumperFactoryFactory :: ~VisMidiDumperFactoryFactory
//------------------------------------------------------------------------------
#pragma export (VisMidiDumperFactoryFactory::~VisMidiDumperFactoryFactory())
VisMidiDumperFactoryFactory::~VisMidiDumperFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// VisMidiDumperFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (VisMidiDumperFactoryFactory::create())
Dumper * VisMidiDumperFactoryFactory::create()
{
   Dumper *iDumperFactory = new Dumper(
      id+WNDOFFSET_VisMidi_DumperFactory, 
      IWindow::desktopWindow(), 
      0, 
      Dumper::defaultFramingSpec());
   iDumperFactory->enableNotification();
   iDumperFactory->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iDumperFactory)));
   return(iDumperFactory);
}

#pragma export (VisMidi::readyId)
const INotificationId VisMidi::readyId = "VisMidi::readyId";

//------------------------------------------------------------------------------
// VisMidi :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (VisMidi::defaultFramingSpec())
const IRectangle VisMidi::defaultFramingSpec()
{
   return(IRectangle(IPoint(35, IWindow::desktopWindow()->size().height() - 53 - 470),ISize(642, 470)));
}


//------------------------------------------------------------------------------
// VisMidi :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (VisMidi::defaultTitle())
IString VisMidi::defaultTitle()
{
   return("Real Time MIDI");
}


//------------------------------------------------------------------------------
// VisMidi :: VisMidi
//------------------------------------------------------------------------------
#pragma export (VisMidi::VisMidi(unsigned long, IWindow *, IWindow *, const IRectangle &, const IFrameWindow::Style &, const char *))
VisMidi::VisMidi(
      unsigned long id, 
      IWindow * parent, 
      IWindow * owner, 
      const IRectangle & rect, 
      const IFrameWindow::Style & style, 
      const char * title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iFrameWindowMenu = new IMenuBar(this);
   iFrameWindowMenu->addText(id+WNDOFFSET_VisMidi_fileMenuCascade, "~File").addSubmenu(id+WNDOFFSET_VisMidi_fileMenuCascade);
   iFrameWindowMenu->addSeparator(id+WNDOFFSET_VisMidi_MenuSeparator1, id+WNDOFFSET_VisMidi_fileMenuCascade);
   iFrameWindowMenu->addText(id+WNDOFFSET_VisMidi_exitMenuItem, "E~xit \tF3", id+WNDOFFSET_VisMidi_fileMenuCascade);
   iFrameWindowMenu->addText(id+WNDOFFSET_VisMidi_helpMenuCascade, "~Help").addSubmenu(id+WNDOFFSET_VisMidi_helpMenuCascade);
   iFrameWindowMenu->addSeparator(id+WNDOFFSET_VisMidi_MenuSeparator6, id+WNDOFFSET_VisMidi_helpMenuCascade);
   iFrameWindowMenu->addText(id+WNDOFFSET_VisMidi_prodInfoMenuItem, "Product information", id+WNDOFFSET_VisMidi_helpMenuCascade);
   iFrameWindowAccelTable = new IAccelerator(id+WNDOFFSET_VisMidi_FrameWindow, this);
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iClassContainer = new IVBContainerControl< IMidiClass*, IVSequence<IMidiClass*>, VisMidiClassContainerCnrObj >(
      id+WNDOFFSET_VisMidi_ClassContainer, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle ( ), 
      IContainerControl::defaultStyle() | IContainerControl::readOnly);
   iContainerColumn1 = new IContainerColumn(offsetof(VisMidiClassContainerCnrObj, iname), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iContainerColumn2 = new IContainerColumn(offsetof(VisMidiClassContainerCnrObj, inumber), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iContainerColumn3 = new IContainerColumn(offsetof(VisMidiClassContainerCnrObj, inumSlots), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iContainerColumn4 = new IContainerColumn(offsetof(VisMidiClassContainerCnrObj, iattributes), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iInstanceContainer = new IVBContainerControl< IMidiInstance*, IVSequence<IMidiInstance*>, VisMidiInstanceContainerCnrObj >(
      id+WNDOFFSET_VisMidi_InstanceContainer, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle ( ));
   iContainerColumn5 = new IContainerColumn(VisMidiInstanceContainerCnrObj::iconTextOffset(), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iContainerColumn6 = new IContainerColumn(offsetof(VisMidiInstanceContainerCnrObj, iclassNum), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iContainerColumn7 = new IContainerColumn(offsetof(VisMidiInstanceContainerCnrObj, inumLinks), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iContainerColumn8 = new IContainerColumn(offsetof(VisMidiInstanceContainerCnrObj, iattributes), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::string | IContainerColumn::number);
   iContainerColumn9 = new IContainerColumn(offsetof(VisMidiInstanceContainerCnrObj, iattribString), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iSetCanvas1 = new ISetCanvas(
      id+WNDOFFSET_VisMidi_SetCanvas1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText2 = new IStaticText(
      id+WNDOFFSET_VisMidi_StaticText2, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iStaticText1 = new IStaticText(
      id+WNDOFFSET_VisMidi_StaticText1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iStaticText3 = new IStaticText(
      id+WNDOFFSET_VisMidi_StaticText3, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iPushButton1 = new IPushButton(
      id+WNDOFFSET_VisMidi_PushButton1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iRTMidi = new IRTMidi();
   iInfoFactory = new VisMidiInfoFactoryFactory(id);
   iInfoWindow = new IVBVariablePartPointer<Info *>();
   iKeyboardFactory = new VisMidiKeyboardFactoryFactory(id);
   iPatchFactory = new VisMidiPatchFactoryFactory(id);
   iProfile = new IProfile("VisMIDI.ini");
   iDumperFactory = new VisMidiDumperFactoryFactory(id);
   iWindowSeq = new IVSequence< IFrameWindow * >();

   conn10 = new VisMidiConn10();
   conn9 = new VisMidiConn9();
   conn19 = new VisMidiConn19();
   conn11 = new VisMidiConn11(id);
   conn12 = new VisMidiConn12();
   conn25 = new VisMidiConn25();
   conn26 = new VisMidiConn26();
   conn39 = new VisMidiConn39();
   conn65 = new VisMidiConn65();
   conn44 = new VisMidiConn44();
   conn35 = new VisMidiConn35();
   conn45 = new VisMidiConn45();
   conn54 = new VisMidiConn54();
   conn29 = new VisMidiConn29(id);
   conn6 = new VisMidiConn6(id);
   conn37 = new VisMidiConn37();
   conn28 = new VisMidiConn28();
   conn24 = new VisMidiConn24();

   iMultiCellCanvas1->addToCell(iClassContainer, 2, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iInstanceContainer, 2, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iSetCanvas1, 2, 4, 1, 1);
   iMultiCellCanvas1->setColumnWidth(1, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setColumnWidth(3, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), false);
   iMultiCellCanvas1->setRowHeight(5, IMultiCellCanvas::defaultCell().height(), false);
   iClassContainer->setTitleAlignment(IContainerControl::left);
   iClassContainer->showDetailsView();
   iClassContainer->showTitle(true);
   iClassContainer->setMinimumSize(ISize(592, 140));
   iClassContainer->showTitleSeparator(true);
   iClassContainer->setTitle("MIDI Classes");
   iClassContainer->addColumn(iContainerColumn1);
   iClassContainer->addColumn(iContainerColumn2);
   iClassContainer->addColumn(iContainerColumn3);
   iClassContainer->addColumn(iContainerColumn4);
   iContainerColumn1->setHeadingText("Name");
   iContainerColumn2->setHeadingText("Number");
   iContainerColumn3->setHeadingText("Slots");
   iContainerColumn4->setHeadingText("Attributes");
   iInstanceContainer->setRefreshOn(true);
   iInstanceContainer->showDetailsView();
   iInstanceContainer->setMinimumSize(ISize(592, 199));
   iInstanceContainer->showTitle(true);
   iInstanceContainer->setTitleAlignment(IContainerControl::left);
   iInstanceContainer->showTitleSeparator(true);
   iInstanceContainer->setTitle("MIDI Instances");
   iInstanceContainer->addColumn(iContainerColumn5);
   iInstanceContainer->addColumn(iContainerColumn6);
   iInstanceContainer->addColumn(iContainerColumn7);
   iInstanceContainer->addColumn(iContainerColumn8);
   iInstanceContainer->addColumn(iContainerColumn9);
   iContainerColumn5->setHeadingText("Name");
   iContainerColumn6->setHeadingText("Class");
   iContainerColumn7->setHeadingText("Links");
   iContainerColumn8->setHeadingText("Attributes");
   iContainerColumn9->setHeadingText("CS CR S R");
   iStaticText2->setText("RTMIDI Return Code");
   iStaticText2->setMinimumSize(ISize(162, 24));
   iStaticText1->setText("RC");
   iStaticText1->setMinimumSize(ISize(52, 24));
   iStaticText3->setText("StaticText3");
   iStaticText3->setMinimumSize(ISize(285, 30));
   iPushButton1->setText("Reset");
   iPushButton1->setMinimumSize(ISize(59, 34));
   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iInfoFactory->setRTMidi(iRTMidi);
   iPatchFactory->setRTMidi(iRTMidi);
   iProfile->setDefaultApplicationName("VisMIDI");
}     //end constructor


//------------------------------------------------------------------------------
// VisMidi :: ~VisMidi
//------------------------------------------------------------------------------
#pragma export (VisMidi::~VisMidi())
VisMidi::~VisMidi()
{
   conn10->stopHandlingNotificationsFor(*this);
   conn9->stopHandlingNotificationsFor(*iRTMidi);
   conn9->stopHandlingNotificationsFor(*iClassContainer);
   conn19->stopHandlingNotificationsFor(*iRTMidi);
   conn19->stopHandlingNotificationsFor(*iInstanceContainer);
   conn11->stopHandlingNotificationsFor(*this);
   conn12->stopHandlingNotificationsFor(*iInfoFactory);
   conn25->stopHandlingNotificationsFor(*this);
   conn26->stopHandlingNotificationsFor(*this);
   conn39->stopHandlingNotificationsFor(*this);
   conn65->stopHandlingNotificationsFor(*this);
   conn44->stopHandlingNotificationsFor(*iRTMidi);
   conn44->stopHandlingNotificationsFor(*iStaticText3);
   conn35->stopHandlingNotificationsFor(*iPushButton1);
   conn45->stopHandlingNotificationsFor(*iRTMidi);
   conn45->stopHandlingNotificationsFor(*iStaticText1);
   conn54->stopHandlingNotificationsFor(*this);
   conn29->stopHandlingNotificationsFor(*this);
   conn6->stopHandlingNotificationsFor(*this);
   conn37->stopHandlingNotificationsFor(*iDumperFactory);
   conn28->stopHandlingNotificationsFor(*iKeyboardFactory);
   conn24->stopHandlingNotificationsFor(*iPatchFactory);

   delete conn10;
   delete conn9;
   delete conn19;
   delete conn11;
   delete conn12;
   delete conn25;
   delete conn26;
   delete conn39;
   delete conn65;
   delete conn44;
   delete conn35;
   delete conn45;
   delete conn54;
   delete conn29;
   delete conn6;
   delete conn37;
   delete conn28;
   delete conn24;

   delete iFrameWindowMenu;

   delete iFrameWindowAccelTable;
   delete iMultiCellCanvas1;
   delete iClassContainer;
   delete iContainerColumn1;
   delete iContainerColumn2;
   delete iContainerColumn3;
   delete iContainerColumn4;
   delete iInstanceContainer;
   delete iContainerColumn5;
   delete iContainerColumn6;
   delete iContainerColumn7;
   delete iContainerColumn8;
   delete iContainerColumn9;
   delete iSetCanvas1;
   delete iStaticText2;
   delete iStaticText1;
   delete iStaticText3;
   delete iPushButton1;
   delete iRTMidi;
   delete iInfoFactory;
   delete iInfoWindow;
   delete iKeyboardFactory;
   delete iPatchFactory;
   delete iProfile;
   delete iDumperFactory;
   delete iWindowSeq;
}

//------------------------------------------------------------------------------
// VisMidi :: initializePart
//------------------------------------------------------------------------------
#pragma export (VisMidi::initializePart())
VisMidi & VisMidi::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// VisMidi :: makeConnections
//------------------------------------------------------------------------------
#pragma export (VisMidi::makeConnections())
Boolean VisMidi::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iClassContainer->enableNotification();
   iInstanceContainer->enableNotification();
   iSetCanvas1->enableNotification();
   iStaticText2->enableNotification();
   iStaticText1->enableNotification();
   iStaticText3->enableNotification();
   iPushButton1->enableNotification();
   iRTMidi->enableNotification();
   iInfoFactory->enableNotification();
   iInfoWindow->enableNotification();
   iKeyboardFactory->enableNotification();
   iPatchFactory->enableNotification();
   iDumperFactory->enableNotification();
   iWindowSeq->enableNotification();

   unsigned long id = this->id();
   conn10->initialize(this, iRTMidi);
   conn10->handleNotificationsFor(*this);
   conn9->initialize(iRTMidi, iClassContainer);
   conn9->handleNotificationsFor(*iRTMidi);
   conn9->handleNotificationsFor(*iClassContainer);
   conn19->initialize(iRTMidi, iInstanceContainer);
   conn19->handleNotificationsFor(*iRTMidi);
   conn19->handleNotificationsFor(*iInstanceContainer);
   conn11->initialize(iFrameWindowMenu, iInfoFactory);
   conn11->handleNotificationsFor(*this);
   conn12->initialize(iInfoFactory, iInfoWindow);
   conn12->handleNotificationsFor(*iInfoFactory);
   conn25->initialize(this, iKeyboardFactory);
   conn25->handleNotificationsFor(*this);
   conn26->initialize(this, iDumperFactory);
   conn26->handleNotificationsFor(*this);
   conn39->initialize(this, iPatchFactory);
   conn39->handleNotificationsFor(*this);
   conn65->initialize(this, this);
   conn65->handleNotificationsFor(*this);
   conn44->initialize(iRTMidi, iStaticText3);
   conn44->handleNotificationsFor(*iRTMidi);
   conn44->handleNotificationsFor(*iStaticText3);
   conn35->initialize(iPushButton1, iRTMidi);
   conn35->handleNotificationsFor(*iPushButton1);
   conn45->initialize(iRTMidi, iStaticText1);
   conn45->handleNotificationsFor(*iRTMidi);
   conn45->handleNotificationsFor(*iStaticText1);
   conn54->initialize(this, this);
   conn54->handleNotificationsFor(*this);
   conn54->setProfile(iProfile);
   conn65->setProfile(iProfile);
   conn29->initialize(iFrameWindowMenu, iWindowSeq);
   conn29->handleNotificationsFor(*this);
   conn6->initialize(iFrameWindowMenu, this);
   conn6->handleNotificationsFor(*this);
   conn37->initialize(iDumperFactory, iWindowSeq);
   conn37->handleNotificationsFor(*iDumperFactory);
   conn28->initialize(iKeyboardFactory, iWindowSeq);
   conn28->handleNotificationsFor(*iKeyboardFactory);
   conn24->initialize(iPatchFactory, iWindowSeq);
   conn24->handleNotificationsFor(*iPatchFactory);

   conn9->setTarget();
   conn19->setTarget();
   conn44->setTarget();
   conn45->setTarget();
   return true;
}



#include "VisMidi.cpv"
