/*******************************************************************************
* FILE NAME: IMidiCls.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     IMidi- Real Time Midi Class Class                                        *
*******************************************************************************/

#ifndef _IMIDICLS_
#include "IMidiCls.hpp"
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif

#include <string.h>

//------------------------------------------------------------------------------
// IMidiClass :: IMidiClass
//------------------------------------------------------------------------------
IMidiClass::IMidiClass( PMIDICLASSINFO i )
{
   IFUNCTRACE_DEVELOP();
   memcpy( &theInfo, i, sizeof( MIDICLASSINFO ) );
   theName = theInfo.szmClassName;
}


//------------------------------------------------------------------------------
// IMidiClass :: ~IMidiClass
//------------------------------------------------------------------------------
IMidiClass::~IMidiClass()
{
   IFUNCTRACE_DEVELOP();
}


//------------------------------------------------------------------------------
// IMidiClass :: number
//------------------------------------------------------------------------------
unsigned long IMidiClass::number() const
{
   IFUNCTRACE_DEVELOP();
   return theInfo.ulClassNumber;
}


//------------------------------------------------------------------------------
// IMidiClass :: name
//------------------------------------------------------------------------------
IString IMidiClass::name() const
{
   IFUNCTRACE_DEVELOP();
   return theName;
}


//------------------------------------------------------------------------------
// IMidiClass :: numSlots
//------------------------------------------------------------------------------
unsigned long IMidiClass::numSlots() const
{
   IFUNCTRACE_DEVELOP();
   return theInfo.ulNumSlots;
}


//------------------------------------------------------------------------------
// IMidiClass :: attributes
//------------------------------------------------------------------------------
unsigned long IMidiClass::attributes() const
{
   IFUNCTRACE_DEVELOP();
   return theInfo.ulAttributes;
}


