/*******************************************************************************
* FILE NAME: imidicls.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     imidicls- Real Time Midi Class Class                                     *
*******************************************************************************/
#ifndef _IMIDICLS_
#define _IMIDICLS_

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#include <istring.hpp>

#ifndef _IRTMIDI_
#include <irtmidi.hpp>
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

#pragma library("rtmidi.lib")
#pragma library("irtmidi.lib")

//*****************************************************************************
// Class definition for IRTMidi
//*****************************************************************************
class _Export IMidiClass : public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   IMidiClass( PMIDICLASSINFO );
   virtual  ~IMidiClass();

public:
  unsigned long number()     const;
  IString       name()       const;
  unsigned long numSlots()   const;
  unsigned long attributes() const;

private:
  MIDICLASSINFO        theInfo;
  IString              theName;

};   //IMidiClass


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
