/*******************************************************************************
* FILE NAME: IMidiDmp.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMidiDumper - MIDI Datastream Dump                                       *
*******************************************************************************/
#ifndef _IMIDIDMP_
#define _IMIDIDMP_

class IMidiDumper;

#ifndef _IMIDIINS_
#include <imidiins.hpp>
#endif

#ifndef _ITHREAD_
#include <ithread.hpp>
#endif

#ifndef _IMLE_
#include <imle.hpp>
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//*****************************************************************************
// Class definition for IMidiKeyboard
//*****************************************************************************
class _Export IMidiDumper : public IMidiInstance {
public:
   typedef IMidiInstance Inherited;
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   IMidiDumper();

   virtual  ~IMidiDumper();

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   virtual IMidiDumper & initializePart();
   virtual IMidiDumper & startDumper( IMultiLineEdit * );
   virtual IMidiDumper & stopDumper();

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId readyId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   Boolean makeConnections();
   virtual void updateAttributes();
   virtual void dumper();

private:
   IMultiLineEdit * iMLE;
   IThreadMemberFn< IMidiDumper > * dumpThread;
   IThread theThread;
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
