/*******************************************************************************
* FILE NAME: imidiins.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     imidicls- Real Time Midi Class Class                                     *
*******************************************************************************/
#ifndef _IMIDIINS_
#define _IMIDIINS_

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#include <istring.hpp>

#ifndef _IRTMIDI_
#include <irtmidi.hpp>
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

#pragma library("rtmidi.lib")
#pragma library("irtmidi.lib")

//*****************************************************************************
// Class definition for IMidiInstance
//*****************************************************************************
class _Export IMidiInstance : public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   IMidiInstance( PMIDIINSTANCEINFO );
   virtual  ~IMidiInstance();

public:
   MINSTANCE     instance()     const;
   unsigned long classNum()     const;
   IString       name()         const;
   unsigned long numLinks()     const;
   unsigned long attributes()   const;

   virtual IMidiInstance & initializePart();

   virtual void setInfo( PMIDIINSTANCEINFO );
   virtual Boolean canSend() const;
   virtual Boolean isSend() const;
   virtual IMidiInstance & enableSend( Boolean enable=true );
   virtual Boolean canReceive() const;
   virtual Boolean isReceive() const;
   virtual IMidiInstance & enableReceive( Boolean enable=true );
   virtual IString attribString() const;
   virtual IMidiInstance & addLink( IMidiInstance * );
   virtual IMidiInstance & removeLink( IMidiInstance * );

   // Notification IDs
   static const INotificationId attribStringId;
   static const INotificationId readyId;

protected:
   Boolean makeConnections();
   virtual void updateAttributes();
   void sendMessage( BYTE b1, BYTE b2, BYTE b3, BYTE b4 ) const;

   MIDIINSTANCEINFO theInfo;

private:
   void genAttribString();

   IString          theName;
   IString          iAttribString;

};   //IMidiInstance


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
