/*******************************************************************************
* FILE NAME: IMidiKbd.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     IMidiKeyboard- MIDI Keyboard                                             *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _IMIDIKBD_
#include "IMidiKbd.hpp"
#endif

#ifndef _IMIDICLS_
#include "IMidiCls.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


const INotificationId IMidiKeyboard::readyId = "IMidiKeyboard::readyId";

//------------------------------------------------------------------------------
// IMidiKeyboard :: IMidiKeyboard
//------------------------------------------------------------------------------
IMidiKeyboard::IMidiKeyboard()
  : IMidiInstance( NULL ),
    iVolume( 127 ),
    iChannel( 1 )
{
   IFUNCTRACE_DEVELOP();
   // Create application instance
   MINSTANCE AppInstance = IRTMidi::theIRTMidi->addInstance(
                       this,
                       IRTMidi::theIRTMidi->applicationClass()->number(),
                       "SoftKeyboard" );
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: updateAttributes
//------------------------------------------------------------------------------
void IMidiKeyboard::updateAttributes()
{
   IFUNCTRACE_DEVELOP();
   theInfo.ulAttributes = MIDI_INST_ATTR_CAN_SEND;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: ~IMidiKeyboard
//------------------------------------------------------------------------------
IMidiKeyboard::~IMidiKeyboard()
{
   IFUNCTRACE_DEVELOP();
}

//------------------------------------------------------------------------------
// IMidiKeyboard :: initializePart
//------------------------------------------------------------------------------
IMidiKeyboard & IMidiKeyboard::initializePart()
{
   IFUNCTRACE_DEVELOP();
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: makeConnections
//------------------------------------------------------------------------------
Boolean IMidiKeyboard::makeConnections()
{
   IFUNCTRACE_DEVELOP();
   this->enableNotification();
   return true;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: volume
//------------------------------------------------------------------------------
unsigned short IMidiKeyboard::volume() const
{
   IFUNCTRACE_DEVELOP();
  return iVolume;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: setVolume
//------------------------------------------------------------------------------
IMidiKeyboard & IMidiKeyboard::setVolume( unsigned short v )
{
   IFUNCTRACE_DEVELOP();
   if ( v <= 127 )
      iVolume = v;
   else
      iVolume = 127;
   sendVolume();
   return *this;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: sendVolume (private)
//------------------------------------------------------------------------------
void IMidiKeyboard::sendVolume()
{
   IFUNCTRACE_DEVELOP();
   if ( isSend() )
   {
      // Send volume control message
      sendMessage( 0xb0 + iChannel - 1,  // Control change
                   0x07,                 // Channel volume
                   iVolume,              // volume MSB
                   0x00 );
   }
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: sendPatch (private)
//------------------------------------------------------------------------------
void IMidiKeyboard::sendPatch()
{
   IFUNCTRACE_DEVELOP();
   if ( isSend() )
   {
      // Send patch change
      sendMessage( 0xc0 + iChannel - 1,  // Program change
                   iPatch,               // Channel volume
                   0x00,
                   0x00 );
   }
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: channel
//------------------------------------------------------------------------------
unsigned short IMidiKeyboard::channel() const
{
   IFUNCTRACE_DEVELOP();
   return iChannel;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: setChannel
//------------------------------------------------------------------------------
IMidiKeyboard & IMidiKeyboard::setChannel( unsigned short c )
{
   IFUNCTRACE_DEVELOP();
   if ( c == 0 )
      iChannel = 1;
   else
   if ( c > 16 )
      iChannel = 16;
   else
      iChannel = c;
   sendVolume();
   return *this;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: patch
//------------------------------------------------------------------------------
unsigned short IMidiKeyboard::patch() const
{
   IFUNCTRACE_DEVELOP();
   return iPatch;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: setPatch
//------------------------------------------------------------------------------
IMidiKeyboard & IMidiKeyboard::setPatch( unsigned short p )
{
   IFUNCTRACE_DEVELOP();
   if ( p >127 )
      iPatch = 0;
   else
      iPatch = p;
   sendPatch();
   return *this;
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: keyDown
//------------------------------------------------------------------------------
void IMidiKeyboard::keyDown( unsigned short key ) const
{
   IFUNCTRACE_DEVELOP();
   if ( isSend() )
   {
      // Send note on  message
      sendMessage( 0x90 + iChannel - 1,  // note on
                   key,                  // note
                   0x7f,                 // note velocity
                   0x00 );
   }
}


//------------------------------------------------------------------------------
// IMidiKeyboard :: keyUp
//------------------------------------------------------------------------------
void IMidiKeyboard::keyUp( unsigned short key ) const
{
   IFUNCTRACE_DEVELOP();
   if ( isSend() )
   {
      // Send note off message
      sendMessage( 0x90 + iChannel - 1,  // note on
                   key,                  // note
                   0x00,                 // note velocity (volume) = 0
                   0x00 );
   }
}
