/******************************************************************************
* FILE NAME: IRTMidi.hpp                                                      *
*                                                                             *
* DESCRIPTION:                                                                *
*   Declaration of the class:                                                 *
*     IRTMidi- Real Time Midi Base Class                                      *
*     This class represents the RTMIDI interface.  Only  one instance of this *
*     class chould be created.                                                *
******************************************************************************/
#ifndef _IRTMIDI_
#define _IRTMIDI_

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _IVSEQ_H_
#include <ivseq.h>
#endif

class IMidiClass;
class IMidiInstance;

#ifndef INCL_DOS
#define INCL_DOS
#endif
#define INCL_BASE
#define INCL_ERRORS
#define INCL_DOSQUEUES
#define INCL_NOPMAPI
#include <os2.h>

#include <mididll.h>
#include <meerror.h>

// used for MIDIQueryVersion
#define  MIDIVER_MAJOR   0xC000
#define  MIDIVER_MINOR   0x3C00
#define  MIDIVER_BUGFIX  0x03C0
#define  MIDIVER_PHASE   0x0030
#define  MIDIVER_BUILD   0x000F

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

#pragma library("rtmidi.lib")
#pragma library("irtmidi.lib")

//*****************************************************************************
// Class definition for IRTMidi
//*****************************************************************************
class _Export IRTMidi : public IStandardNotifier {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   IRTMidi();

   virtual  ~IRTMidi();

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   virtual IRTMidi & initializePart();

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId readyId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   Boolean makeConnections();

public:
  virtual IString version()            const;
  virtual unsigned long lastRC()       const;
  virtual void startTimer()            const;
  virtual void stopTimer()             const;

  IVSequence<IMidiClass*>    * classes();
  IVSequence<IMidiInstance*> * instances();
  virtual MINSTANCE addInstance( IMidiInstance *, ULONG, IString );
  virtual void      delInstance( IMidiInstance * );

  virtual IMidiClass * applicationClass();
  virtual IMidiClass * hardwareClass();

  virtual IRTMidi&      setLastRC(unsigned long aLastRC);
  virtual IRTMidi&      resetLastRC( );
  virtual IString       RCExplanation() const;

  static const INotificationId classesId;
  static const INotificationId instancesId;
  static const INotificationId lastRCId;
  static const INotificationId RCExplanationId;

  static IRTMidi * theIRTMidi;

private:
  unsigned long         getClasses();
  void                  delClasses();
  unsigned long         getInstances();
  void                  delInstances();

  unsigned long         iLastRC;
  MIDISETUP             theSetup;
  unsigned long         maxRTSysexLen;
  unsigned long *       currentTime;
  IMidiClass    *       appClass;
  IMidiClass    *       hdwClass;

  IVSequence<IMidiClass*>    iClasses;
  IVSequence<IMidiInstance*> iInstances;

};   //IRTMidi


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
