print "struct CliConst { const char *name; long val; };\n%%\n";
%consts = ();
while (<>) {
    if ((/\bSQL/ || /DB2/ || /ODBC/) && /^#define\s+(\w+)\s/) {
	$consts{$1} = 1;
    }
}
@consts = sort keys %consts;

foreach (@consts) {
    print "$_,$_\n";
}

@funcs = ();
open(IN,  "< DB2CLI.xs") or die "DB2CLI.xs\n";
while (<IN>) {
    if (/^SQL\w+/ && $& ne "SQLRETURN") {
	push @funcs, $&;
    }
}
close(IN);

open(IN,  "< DB2CLI.pm.in") or die "DB2CLI.pm.in\n";
open(OUT, "> DB2CLI.pm")    or die "DB2CLI.pm\n";
while (<IN>) {
    if (/\%\%/) {
	foreach (sort @funcs) {
	    print OUT "\t$_\n";
	}
	foreach (sort @consts) {
	    print OUT "\t$_\n";
	}
    } else {
	print OUT $_;
    }
}
close(IN);
close(OUT);
