use DB2CLI;

SQLAllocEnv($henv)				and message("AllocEnv");
SQLAllocConnect($henv, $hdbc)			and message("AllocConnect");
SQLConnect($hdbc, 'SAMPLE', 'DBA', '')		and message("Connect");
SQLSetConnectOption($hdbc, SQL_AUTOCOMMIT(), SQL_AUTOCOMMIT_OFF());
SQLAllocStmt($hdbc, $hstmt)			and message("AllocStmt");

SQLPrepare($hstmt, <<)				and message("Prepare");
    INSERT INTO admin.emp_photo (empno,photo_format,picture)
           VALUES (?, 'GIF', ?)

SQLExecute2($hstmt,
	    SQL_C_CHAR(), SQL_CHAR(), '998',
	    SQL_C_CHAR(), SQL_BLOB(), "303132")
						and message("Execute2 1");
SQLExecute2($hstmt,
	    SQL_C_CHAR(),   SQL_CHAR(), '999',
	    SQL_C_BINARY(), SQL_BLOB(), "\x41\x42\x43")
						and message("Execute2 2");

SQLTransact($henv, $hdbc, SQL_ROLLBACK());

SQLFreeStmt($hstmt, SQL_DROP())			and message("FreeStmt");
SQLDisconnect($hdbc)				and message("Disconnect");
SQLFreeConnect($hdbc)				and message("FreeConnect");
SQLFreeEnv($henv)				and message("FreeEnv");

exit 0;

sub message
{
    my ($where, $retcode) = @_;
    my ($state, $native, $text);
    if (SQLError($henv, $hdbc, $hstmt, $state, $native, $text) >= 0) {
	print "$where: $state,$native:\n$text\n";
	SQLTransact($henv, $hdbc, SQL_ROLLBACK());
	exit 1;
    }
    print "$where: cannot retrieve error info, retcode=$retcode\n";
    SQLTransact($henv, $hdbc, SQL_ROLLBACK());
    exit 2;
}
