use DPI;

DPI::DPIdebug(2);

$h = DPI::DPIconnect_to_agent_TCP("r0124", "public");
;; print "connect: $h\n";

$data = pack("L", 11223344);
$values = DPI::mkDPIset(0, "1.3.6.1.4.1.2.2.1.5.", "1.0", SNMP_TYPE_Integer32, $data);
;; print "values: $values\n";

$packet = DPI::mkDPItrap(6, 1, $values);
;; print "trap: ", hexdump($packet), "\n";

$rc = DPI::DPIsend_packet_to_agent($h, $packet);
;; print "send: $rc\n";

DPI::DPIdisconnect_from_agent($h);

exit 0;

#############################################################################
sub hexdump
{
    return join(".", map(sprintf("%02X", $_), split(//, $_[0])));
}
