/*****************************************************************************\
| Query user with a prompt asking for a single keystroke response.            |
|                                                                             |
| $Revision:   1.2  $
|     $Date:   20 Oct 1996 21:34:18  $                                        |
| Libraries:   REXXSAA, REXXUTIL, [REXXLIB]                                   |
|  Category:   REXX Function                                                  |
|     Class:   User Interface                                                 |
|      Type:   Input                                                          |
|    Author:   Bob Rice <bobrice@ibm.net>                                     |
|                                                                             |
| Copyright (c) 1995, 1996 Empirical Heuristics                               |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse arg keys, prompt, timeout
  exit AskUser(keys, prompt, timeout)

  /*=========================================================================*\
  | Query user with a prompt asking for a single keystroke response which is  |
  | not echoed to the screen.                                                 |
  \*=========================================================================*/
AskUser: procedure
  parse arg keys, prompt, timeout
  if \datatype(timeout, 'NUM') then timeout = 0 /* If not spec'd, make 0     */
  /*---------------------------------------------*\
  | Build list of acceptable response characters. |
  \*---------------------------------------------*/
  caps = xrange('A','Z')
  default = ''                                  /* Default response          */
  keystr  = ''                                  /* Choices to show user      */
  do i = 1 to length(keys)
    key = substr(keys, i, 1)
    if pos(key, caps) > 0 then default = key    /* Set the default response  */
    keystr = keystr || key || '/'
  end
  keystr = left(keystr, length(keystr) - 1)     /* Remove trailing /         */
  if default = '' then                          /* If user didn't specify    */
    default = Upper(left(keys, 1))              /*   default, pick 1st one   */
  /*---------------*\
  | Query the user. |
  \*---------------*/
  say '['keystr']' prompt
  rexxlib = \ RxFuncQuery('InKey')              /* See if REXXLIB is loaded  */
  call time 'R'                                 /* Reset the timer           */
  if timeout > 0 & rexxlib then do until time('E') >= timeout
     ans = Upper(InKey('N'))                    /* Check for keypress        */
     if ans \== '' then leave                   /* Done if there is one      */
     call Delay 0.1                             /* Wait a while              */
     ans = d2c(13)                              /* Use <Enter> if timeout    */
  end
  else                                          /* Use REXXSAA functions     */
    ans = translate(SysGetKey('NOECHO'))        /*   without using a delay   */
  if c2d(ans) = 13 then ans = default           /* If <Enter>, use default   */
  if pos(ans,translate(keys)) = 0 then ans = default
  return ans
/*--Begin Help-----------------------------------------------------------------
Query user with a prompt asking for a single keystroke response.  The keystroke
is not echoed to the screen.

Params: keys, prompt [,timeout]

  keys        is a string of characters, one of which may be upper cased,
              to tell the user which keystrokes are acceptable.  The upper
              case character denotes the default should the user press
              <Enter> or <Esc> or a character not in the list.  If an upper
              case character is not in the string, then the first character in
              the string will be used.

  prompt      is a character string that will be presented to the user on
              the next available screen line.

  timeout     is the number of seconds to wait for the user to respond before
              returning the default response.  If not supplied, or if specified
              as 0, then the wait is forever.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

Although the use of REXXLIB is optional for this program to run, if REXXLIB is
not installed on the system, or if REXXLIB is not registered to OS/2, the
timeout facility of this program will not function.

___________________
Development History
$Log:   G:/rxdv/skeleton/vcs/askuser.cm!  $

     Rev 1.2   20 Oct 1996 21:34:18
  *  Updated author's address.

     Rev 1.1   20 Oct 1996 20:43:02
  *  Added timeout ability.
  *  If user doesn't specify a default, use first in string.
  *  Added more comments.

     Rev 1.0   03 Aug 1995 20:10:06
  Initial revision.
--End Help-------------------------------------------------------------------*/
