/*****************************************************************************\
| Specify file editor to use to display .cmd code errors.                     |
|                                                                             |
| $Revision:   1.4  $
|     $Date:   07 Dec 1996 14:46:24  $                                        |
| Libraries:   REXXSAA                                                        |
|  Category:   Error Handler                                                  |
|     Class:   Programming                                                    |
|      Type:   Service                                                        |
|    Author:   Bob Rice <bobrice@ibm.net>                                     |
|                                                                             |
| Copyright (c) 1995, 1996 Empirical Heuristics                               |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  /* Move your favorite editor line to the last in the group.                */
  editor = 'BOXER'                        /* Boxer for OS/2 editor           */
  editor = 'EPM'                          /* OS/2 Extended PM Editor         */
  editor = 'E'                            /* Standard OS/2 Editor            */

  parse arg file line .
  if line = '' then line = 1
  /*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
  /*>>>>>>> Customize the following lines to use your favorite editor. <<<<<<*/
  select
    when editor = 'BOXER' then do
      if line = ''
        then '@START "REXX Skeleton Error Handler Editor" /F B2 -lx' file
        else '@START "REXX Skeleton Error Handler Editor" /F B2 -lx -g'line file
    end
    when editor = 'E' then do
      '@START "REXX Skeleton Error Handler Editor" /F E' file
    end
    when editor = 'EPM' then do
      '@START "REXX Skeleton Error Handler Editor" /F EPM' file "'goto" line"'"
    end
    otherwise nop
  end
  exit
/*--Begin Help-----------------------------------------------------------------
Specify file editor to use to display .cmd code errors.  Called by the standard
Skeleton error trap routine.

Params: file-to-edit [error-line-number]

  file-to-edit        is the filespec of the file which the editor is expected
                      to open in the event of an error detected by Skeleton.

  error-line-number   is the line number of the source code in error.  When
                      specified, the editot is opened with the cursor on this
                      line in the file.  Note that this option is ignored by
                      certain editors.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

This program is not intended to be a general utility.  It is designed to
support the standard REXX Skeleton as part of its error and event trap
processor.

___________________
Development History

$Log:   G:/rxdv/skeleton/vcs/erhedit.cm!  $
  
     Rev 1.4   07 Dec 1996 14:46:24
  *  Better titling of opened edit window.

     Rev 1.3   07 Dec 1996 12:18:40
  *  Added the OS/2 E editor as a possible choice.
  *  Changed default editor to the 'E' editor since it's available
     on all OS/2 installations.

     Rev 1.2   20 Oct 1996 22:14:08
  *  Use BOXER's -lx option to inhibit changes to boxer.lst file.

     Rev 1.1   20 Oct 1996 21:54:14
  *  Use SELECT statement to select favorite editor.
  *  Author's address updated.

     Rev 1.0   03 Aug 1995 20:10:10
  Initial revision.
--End Help-------------------------------------------------------------------*/
