/*****************************************************************************\
| Specify file viewer to use to display .cmd code errors.                     |
|                                                                             |
| $Revision:   1.4  $
|     $Date:   07 Dec 1996 14:47:28  $                                        |
| Libraries:   REXXSAA                                                        |
|  Category:   Error Handler                                                  |
|     Class:   Programming                                                    |
|      Type:   Service                                                        |
|    Author:   Bob Rice - CompuServe: 72421,3016                              |
|                                                                             |
| Copyright (c) 1995 Empirical Heuristics                                     |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  /* Move your favorite browser line to the last line in the group.          */
  browser = 'BOXER'                       /* Boxer OS/2 Editor               */
  browser = 'HVPM'                        /* HyperView Browser               */
  browser = 'EPM'                         /* OS/2 Extended PM Editor         */
  browser = 'E'                           /* Standard OS/2 Editor            */

  parse arg file line .
  if line = '' then line = 1
  /*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>><<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
  /*>>>>>>> Customize the following line to use your favorite editor. <<<<<<<*/
  select
    when browser = 'BOXER' then do
      if line = ''
        then '@START "REXX Skeleton Error Handler Viewer" B2 -lx -x' file
        else '@START "REXX Skeleton Error Handler Viewer" B2 -lx -x -g'line file
    end
    when browser = 'E' then do
      '@START "REXX Skeleton Error Handler Viewer" /F E' file
    end
    when browser = 'EPM' then do
      '@START "REXX Skeleton Error Handler Viewer" EPM' file "'goto" line"'"
    end
    when browser = 'HVPM' then do
      '@START "REXX Skeleton Error Handler Viewer" HVPM /E' file
    end
    otherwise nop
  end
  exit
/*--Begin Help-----------------------------------------------------------------
Specify file viewer to use to display .cmd code errors.  Called by the standard
Skeleton error trap routine.

Params: file-to-browse [error-line-number]

  file-to-browse      is the filespec of the file to browse.

  error-line-number   is the line number of the source code in error.  When
                      specified, the browser is opened with the cursor on this
                      line in the file.  Note that this option is ignored by
                      certain browsers.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

This program is not intended to be a general utility.  It is designed to
support the standard REXX Skeleton as part of its error and event trap
processor.

___________________
Development History

$Log:   G:/rxdv/skeleton/vcs/erhview.cm!  $
  
     Rev 1.4   07 Dec 1996 14:47:28
  *  Better titling of opened viewer window.

     Rev 1.3   07 Dec 1996 12:18:56
  *  Added additional possible browsers for selection.
  *  Changed default browser to the 'E' editor since it's available
     on all OS/2 installations.

     Rev 1.2   25 Nov 1996 18:57:44
  *  Fixed bug where wrong variable was used to make browser
     selection.

     Rev 1.1   20 Oct 1996 22:12:48
  *  Use SELECT statement to choose favorite viewer.
  *  Update author's address.

     Rev 1.0   03 Aug 1995 20:10:16
  Initial revision.
--End Help-------------------------------------------------------------------*/
