/*****************************************************************************\
| Checks to see if specified file or directory exists.                        |
|                                                                             |
| $Revision:   1.2  $
|     $Date:   20 Oct 1996 22:16:12  $                                        |
| Libraries:   REXXSAA, REXXUTIL                                              |
|  Category:   REXX Function                                                  |
|     Class:   File Management                                                |
|      Type:   File Existence                                                 |
|    Author:   Bob Rice <bobrice@ibm.net>                                     |
|                                                                             |
| Copyright (c) 1995, 1996 Empirical Heuristics                               |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse arg fn, type .
  exit Exist(fn, type)

  /*=========================================================================*\
  | Check if the specified file exists.                                       |
  \*=========================================================================*/
Exist: procedure
  parse arg fn, type
  if type = '' then type = 'F'
  if pos('M', translate(type)) > 0 then multi = 1
                                   else multi = 0
  rc = SysFileTree(strip(fn), 'stem.', type)
  if      \ multi & rc = 0 & stem.0 = 1 then return 1
  else if   multi & rc = 0 & stem.0 = 1 then return stem.0
                                        else return 0
/*--Begin Help-----------------------------------------------------------------
Checks to see if specified file or directory exists.

Params: search-arg [,type]

search-arg    is a file or directory specification.  Wildcard characters are
              permissible.

type          is the type of search argument as follows:
                F - for a file specification (default)
                D - for a directory specification
                B - for either a file or a directory
              The above three parameters are mutually exclusive.
                M - may be used with any of the above parameters
              When M is not used, the result is always boolean with 1 meaning
              one and only one file or directory matched the specification and
              0 meaning no match was found or multiple matches were found.
              When M is used, the result is the number of matches found.

Note: Result is always boolean, even if multiple matches resulting from the use
      of wildcards are found.
________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this exec and whose extent is .ABS.  The file is written in the same
        directory as that in which this program resides.

_______________
Technical Notes

___________________
Development History

$Log:   G:/rxdv/skeleton/vcs/exist.cm!  $

     Rev 1.2   20 Oct 1996 22:16:12
  *  Update author's address.

     Rev 1.1   20 May 1996 17:02:06
  *  Strip leading and trailing blanks from fn argument.

     Rev 1.0   03 Aug 1995 20:10:16
  Initial revision.
--End Help-------------------------------------------------------------------*/
