/*****************************************************************************\
| Non-destructive dump of REXX data queue contents to file.                   |
|                                                                             |
| $Revision:   1.1  $
|     $Date:   20 Oct 1996 22:23:00  $                                        |
| Libraries:   REXXSAA, REXXUTIL, [REXXLIB]                                   |
|  Category:   Utility                                                        |
|     Class:   Programming                                                    |
|      Type:   Queue                                                          |
|    Author:   Bob Rice <bobrice@ibm.net>                                     |
|                                                                             |
| Copyright (c) 1995, 1996 Empirical Heuristics                               |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */
  if left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

  parse source . howcalled .
  if howcalled = 'COMMAND' then parse arg dumpfile ',' opts
                           else parse arg dumpfile, opts
  if dumpfile = '' then do
    parse source  . . EH.pgm_filespec
    EH.pgm_fnfe = filespec( 'N', EH.pgm_filespec )
    parse var EH.pgm_fnfe EH.pgm_fn '.'
    dumpfile = EH.pgm_fn'.QUE'
  end
  opts = translate(opts)
  if wordpos('/FLUSH', opts) > 0     then flush = 1
                                     else flush = 0
  if wordpos('/OVERWRITE', opts) > 0 then overwrite = 1
                                     else overwrite = 0
  if Exist(dumpfile) & \ overwrite then do
    ans = AskUser('Oa',dumpfile 'already exists. Overwrite or append?')
    if ans = 'O' then call SysFileDelete dumpfile
  end

  newq = RxQueue('CREATE')                      /* Invent a new queue        */
  curq = RxQueue('SET',newq)                    /* Get name of current queue */
  call   RxQueue 'DELETE', newq                 /* Delete invented queue     */
  call   RxQueue 'SET', curq                    /* Switch back to current    */
  qname = curq                                  /* Save current queue name   */
  call ShowQ                                    /* Dump the queue            */

  if curq \= 'SESSION' then do                  /* If current was not SESSION*/
    call RxQueue 'SET', 'SESSION'               /* Change to SESSION queue   */
    qname = 'SESSION'                           /* Save the queue name       */
    call ShowQ                                  /* Dump the queue            */
  end
  call RxQueue 'SET', curq                      /* Change back to original   */
  exit q.0                                      /* Exit with number of entries*/

  /***************************************************************************\
  |                            PROGRAM SUBROUTINES                            |
  \***************************************************************************/
ShowQ:                                          /* Nondestructive dump of que*/
  n = queued()                                  /* Number of lines queued    */
  if n > 0 then do
    do i = 1 to n
      parse pull s.i                            /* Get a queued line         */
      q.i = '['right('000'i,4)']='s.i           /* Format it                 */
    end
    if \ flush then do i = 1 to n
      queue s.i                                 /* Restore line back on queue*/
    end
  end
  q.0 = n                                       /* Number of lines queued    */
  if dumpfile = '' then do
    call lineout dumpfile, copies('-',79)
    call lineout dumpfile, 'Contents of' qname 'data queue has' q.0 'entries:'
    call lineout dumpfile, ''
  end
  if dumpfile = '' & n > 0 then do i = 1 to n
    say q.i
  end
  else do
    call lineout dumpfile, ''
    call lineout dumpfile, copies('-',79)
    call lineout dumpfile, 'Contents of' qname 'data queue has' q.0 'entries:'
    call lineout dumpfile, ''
    call stream  dumpfile, 'C', 'CLOSE'
    if RXFUNCQUERY('filewrite') = 0 then        /* Use REXXLIB function      */
      if n > 0 then call filewrite dumpfile, 'q.', 'A'; else nop
    else do                                     /* Use slower REXXSAA method */
      do i = 1 to q.0
        call lineout dumpfile, q.i
      end
      call stream dumpfile, 'C', 'CLOSE'
    end
  end
  return
/*--Begin Help-----------------------------------------------------------------
Non-destructive dump of REXX data queue contents to a file.

Designed to be called from another REXX program, this program will dump to a
file the contents of the current data queue.  If the current queue is not the
standard SESSION queue, the current queue is dumped first, and then the SESSION
queue is dumped.  This can be very useful when debugging code dealing with
queues.

Params: [file-spec] [, [/FLUSH] [/OVERWRITE]]

where:

  file-spec   is the path and name of the file to which to write the queue
              data.  If not specified, the name defaults to the name of this
              program with a file extent of .QUE and is written to the current
              directory.

  /FLUSH      will flush the queue or queues after dumping them.

  /OVERWRITE  will cause the program to not ask if it okay to overwrite an
              existing .QUE file; it will just overwrite the file.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

___________________
Development History

$Log:   G:/rxdv/skeleton/vcs/quedump.cm!  $
  
     Rev 1.1   20 Oct 1996 22:23:00
  *  Change Category, Class, and Type.
  *  Update author's address.

     Rev 1.0   03 Aug 1995 20:10:22
  Initial revision.
--End Help-------------------------------------------------------------------*/
