/*****************************************************************************\
| Display embedded help information from certain .cmd files.                  |
|                                                                             |
| $Revision:   1.1  $
|     $Date:   20 Oct 1996 22:28:48  $                                        |
| Libraries:   REXXSAA, REXXUTIL, [REXXLIB]                                   |
|  Category:   Utility                                                        |
|     Class:   Programming                                                    |
|      Type:   User Help                                                      |
|    Author:   Bob Rice <bobrice@ibm.net>                                     |
|                                                                             |
| Copyright (c) 1995, 1996 Empirical Heuristics                               |
\**************************************************************************r4*/
/*  !tr! = value('TRACE',,'OS2ENVIRONMENT'); parse source . . !who!          */
/*  if !tr! \= '' then say '--> Entering' !who!; trace value !tr!; nop       */

  parse arg helptype, pgmfile, pgm_ver, pgm_date, prolog_ver
  if wordpos(translate(helptype),'/? /H /HELP -H -HELP') > 0 then helptype = '?'
  if helptype   = '' then helptype = '?'
  if pgmfile    = '' then parse source . . pgmfile
  if pgm_ver    = '' then pgm_ver    = 'Unknown Version'
  if pgm_date   = '' then pgm_date   = 'Unknown Date'
  if prolog_ver = '' then prolog_ver = '<none>'

  drive = filespec('D',pgmfile)
  path  = filespec('P',pgmfile)
  parse value filespec('N',pgmfile) with pgmname '.' .
  absfile = drive || path || pgmname'.abs'
  parse value SysTextScreenSize() with rows .   /* Number of screen rows     */
  rows = rows - 2                               /* Usable rows               */

  /*-------------------------------------*\
  | Read in the file containing the help. |
  \*-------------------------------------*/
  if RXFUNCQUERY('fileread') = 0 then           /* Use RexxLib function      */
    call fileread pgmfile, 'line.',, 'E','CRANDLF'
  else do                                       /* Use slower REXXSAA func   */
    i = 0
    do while lines(pgmfile) > 0
      i = i + 1
      line.i = linein(pgmfile)
    end
    line.0 = i
    call stream pgmfile, 'C', 'CLOSE'
  end

  ?flg  = 0                                     /* Stop at Syntax: or Params:*/
  ??flg = 0                                     /* Stop at Tech Info         */
  /*------------------------------------------*\
  | Extract info from header box and scan past |
  | the program up to where the help begins.   |
  \*------------------------------------------*/
  do i = 1 to line.0
    if pos(left(line.i, 1), '/|\*') > 0 then do
      select
        when pos('Revision:', line.i) > 0 then do
          parse var line.i 'Revision:' pgm_ver '$'
          pgm_ver = strip(pgm_ver)
        end
        when pos('Date:', line.i) > 0 then do
          parse var line.i 'Date:' d m y .
          pgm_date = d m y
        end
      otherwise nop
      end
    end
    if left(line.i, 16) \= '/*--Begin Help--' then iterate
    leave
  end
  /*------------------------------------------*\
  | Write and display some header information. |
  \*------------------------------------------*/
  if helptype = '????' then do
    call SysFileDelete absfile
    call lineout absfile, pgmfile '--' pgm_ver '--' pgm_date
    call lineout absfile, ''
  end
  say pgmfile
  j = 1
  if prolog_ver \= '<none>' then do
    say ' Prolog version:' prolog_ver
    j = j + 1
  end
  say 'Program version:' pgm_ver '--' pgm_date
  say
  j = j + 2                                     /* Output line counter       */
  /*-----------------------------*\
  | Display the help information. |
  \*-----------------------------*/
  do i = i + 1 to line.0
    if left(line.i, 12) = '--End Help--' then leave
    if wordpos('Syntax:', line.i) = 1 |,
       wordpos('Params:', line.i) = 1 then ?flg = 1
    if ?flg & helptype = '?' & line.i = '' then leave
    if wordpos('Technical Notes', line.i) = 1 then ??flg = 1
    if ??flg & helptype = '??' then leave
    if helptype = '????' then call lineout absfile, line.i
    else do
      say line.i
      j = j + 1
      if j // rows = 0 then do
        ans = AskUser('Cq','Continue or quit?')
        if ans = 'Q' then exit
      end
    end
  end
  /*----------------------------------*\
  | Write some trailer information or  |
  | scroll screen up for nice display. |
  \*----------------------------------*/
  if helptype = '????' then do
    call lineout absfile, ''
    call lineout absfile, '(Prolog version:' prolog_ver')'
    call stream  absfile, 'C', 'CLOSE'
    say 'Help abstract put in file' absfile'.'
  end
  else do                                      /* Scroll screen up          */
    if j < rows - 2 & helptype = '?' then do
      say
      say 'Note: A parameter of ?? will display additional help.'
      j = j + 2
    end
    do while j // rows <> 0
      say
      j = j + 1
    end
  end
  exit
/*--Begin Help-----------------------------------------------------------------
From a .cmd file, display all or part of the embedded help information between
the Begin Help marker line and the End Help marker line.  If available, the
program version and date are extracted from the .cmd file header box.  In
addition, if the .cmd file employs the standard REXX Skeleton, the prolog
version is also included in the information displayed.  All this information
may optionally be placed in an abstract file.  See the Technical Notes for
additional information.

Params: [help-type [, pgm-fspec, [, pgm-ver [, pgm-date [, prolog-ver] ] ] ] ]

where:

  help-type     specifies how much help you want to see or what to do with it.
                This parameter can be one of the following:

                  [ ?  | /?  | /h | /help | -h | -help ]    displays from the
                        beginning of the embedded help up to the first blank
                        line after a line starting, not necessarily in column
                        1, with either of the strings "Syntax:" or "Params:".
                        The case of these two strings is important, but the
                        case of the parameter itself is not.  If neither of
                        these strings is found, all the help is displayed.
                        This is the value assumed if none is given.

                  ??    displays from the beginning of the embedded help up to,
                        but not including, a line starting, not necessarily in
                        column 1, with the string "Technical Notes", such a
                        line is available.  Case is important.  If this string
                        is not found, all the help is displayed.

                  ???   displays from the beginning of the embedded help up to,
                        but not including, the End Help marker line.  Case is
                        important.  If the End Help marker line is not found,
                        all remaining lines will be displayed.

                  ????  performs like ??? but the help information is placed
                        in an abstract file instead of being displayed on the
                        screen.  The name of the file is extracted from
                        pgm-fspec and a file extent of .ABS is used.

  pgm-fspec     is the filespec of the program file for which you want the help
                extracted.  If this parameter is not specified, then this
                program is assumed.

  pgm-ver       is the version number of the program specified in the pgm-fspec
                parameter.  If this parameter is not specified, then 'Unknown
                Version' is used.

  pgm-date      is the date of the program specified in the pgm-fspec
                parameter.  If this parameter is not specified, then
                'Unknown Date' is used.

  prolog-ver    is the version number of the skeletal prolog in the program
                named in the pgm-spec parameter.  If this parameter is not
                specified, then '<none>' is used.

Note:  For "ordinary" use, the above three parameters should not be used.
Although you may choose to use them, they are provided for the use of the
prolog in the standard REXX Skeleton.  The definition and specifications for
these three parameters may change in future releases.

________________
Alternate Params: [ ? | ?? | ??? | ???? ]

where:

  ?     Displays up to the "Syntax:" or "Params:" portion of this help text.

  ??    Displays this entire help text except for the technical information.

  ???   Displays this entire help text.

  ????  Puts this help text into a file whose name is the same as the name of
        this program and whose extent is .ABS.  The file is written to the same
        directory as that in which this program resides.

_______________
Technical Notes

This program is intended to be used as both a general utility and as part of
the standard REXX Skeleton.

The Begin Help marker line is a line beginning in column 1 with the REXX open
comment delimiter pair (slash asterisk) followed by the string "--Begin Help--"
in columns 3 through 16.  The End Help marker line is a line containing the
string "--End Help--" in columns 1 through 12 and followed somewhere on the
same line by the REXX close comment delimiter pair (asterisk slash).

The header box is considered to be all lines, starting from line 1 of the file,
which have one of the four characters /, |, \, or * in column 1 of the line.
Within the header box are several field labels, of which the Revision: and
Date: are of immediate interest.  This program searches for these strings in
the header box to determine the program version and date, respectively.  The
program version is considered to be anything following the Revision: label.
The date must be of the form dd Mmm yyyy.  The first three tokens following the
Date: label are considered to be the date.  See the header box in this file as
an example.  (The dollar signs in this particular example are there for
compatibility with my version control system and may be eliminated if desired.
The additional labels shown in this header box are not used by this help
extraction program, but are there for the use of a possible follow-on program
to catalog .cmd files.)

If you wish to utilize the abilities of this program to display embedded help
text from your own code, here are some suggested code fragments to use at the
beginning of your program.  Use the following if it is valid to call your
program with no parameters:

  if left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

If your program requires at least one parameter, use the following:

  if arg(1) = '' | left(arg(1),1) = '?' then do
    parse source . . !pgm!; call TellHelp arg(1), !pgm!; exit 2; end

Note that this program will run a bit faster if REXXLIB has been loaded and
registered, although REXXLIB is not a requirement.

___________________
Development History

$Log:   G:/rxdv/skeleton/vcs/tellhelp.cm!  $

     Rev 1.1   20 Oct 1996 22:28:48
  *  Change Category, Class, and Type.
  *  Update author's address.

     Rev 1.0   03 Aug 1995 20:11:28
  Initial revision.
--End Help-------------------------------------------------------------------*/
