#ifndef __ctype_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __ctype_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <ctype.h> Header File                                           */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   /* masks for using external character table */
   #ifndef __ISXDIGIT
      #define __ISXDIGIT       0x0001U
   #endif
   #ifndef __ISDIGIT
      #define __ISDIGIT        0x0002U
   #endif
   #ifndef __ISSPACE
      #define __ISSPACE        0x0008U
   #endif
   #ifndef __ISPUNCT
      #define __ISPUNCT        0x0010U
   #endif
   #ifndef __ISCNTRL
      #define __ISCNTRL        0x0020U
   #endif
   #ifndef __ISLOWER
      #define __ISLOWER        0x0040U
   #endif
   #ifndef __ISUPPER
      #define __ISUPPER        0x0080U
   #endif
   #ifndef __ISALPHA
      #define __ISALPHA        0x0100U
   #endif
   #ifndef __ISGRAPH
      #define __ISGRAPH        0x0200U
   #endif
   #ifndef __ISPRINT
      #define __ISPRINT        0x0400U
   #endif
   #ifndef __ISALNUM
      #define __ISALNUM        0x0800U
   #endif
   #ifndef __ISBLANK
      #define __ISBLANK        0x1000U
   #endif

   #ifdef _WIN32S
      extern const unsigned short** _IMPORT _LNK_CONV __ctype( void );
      extern const short** _IMPORT _LNK_CONV __toupptbl( void );
      extern const short** _IMPORT _LNK_CONV __tolowtbl( void );
      #define _ctype (*__ctype())
      #define _toupptbl (*__toupptbl())
      #define _tolowtbl (*__tolowtbl())
   #else
      extern const unsigned short* _IMPORT _ctype;
      extern const short* _IMPORT _toupptbl;
      extern const short* _IMPORT _tolowtbl;
   #endif

   #if __cplusplus
      inline int _LNK_CONV isalnum (int __c)
                          { return _ctype[__c] & __ISALNUM; }
      inline int _LNK_CONV isalpha (int __c)
                          { return _ctype[__c] & __ISALPHA; }
      inline int _LNK_CONV iscntrl (int __c)
                          { return _ctype[__c] & __ISCNTRL; }
      inline int _LNK_CONV isdigit (int __c)
                          { return _ctype[__c] & __ISDIGIT; }
      inline int _LNK_CONV isgraph (int __c)
                          { return _ctype[__c] & __ISGRAPH; }
      inline int _LNK_CONV islower (int __c)
                          { return _ctype[__c] & __ISLOWER; }
      inline int _LNK_CONV isprint (int __c)
                          { return _ctype[__c] & __ISPRINT; }
      inline int _LNK_CONV ispunct (int __c)
                          { return _ctype[__c] & __ISPUNCT; }
      inline int _LNK_CONV isspace (int __c)
                          { return _ctype[__c] & __ISSPACE; }
      inline int _LNK_CONV isupper (int __c)
                          { return _ctype[__c] & __ISUPPER; }
      inline int _LNK_CONV isxdigit(int __c)
                          { return _ctype[__c] & __ISXDIGIT; }
      inline int _LNK_CONV tolower (int __c)
                          { return _tolowtbl[__c]; }
      inline int _LNK_CONV toupper (int __c)
                          { return _toupptbl[__c]; }
   #else
      extern int _IMPORT _LNK_CONV isalnum(int);
      extern int _IMPORT _LNK_CONV isalpha(int);
      extern int _IMPORT _LNK_CONV iscntrl(int);
      extern int _IMPORT _LNK_CONV isdigit(int);
      extern int _IMPORT _LNK_CONV isgraph(int);
      extern int _IMPORT _LNK_CONV islower(int);
      extern int _IMPORT _LNK_CONV isprint(int);
      extern int _IMPORT _LNK_CONV ispunct(int);
      extern int _IMPORT _LNK_CONV isspace(int);
      extern int _IMPORT _LNK_CONV isupper(int);
      extern int _IMPORT _LNK_CONV isxdigit(int);
      extern int _IMPORT _LNK_CONV tolower(int);
      extern int _IMPORT _LNK_CONV toupper(int);

      #define isalnum(c)  ( _ctype[c] & __ISALNUM )
      #define isalpha(c)  ( _ctype[c] & __ISALPHA )
      #define iscntrl(c)  ( _ctype[c] & __ISCNTRL )
      #define isdigit(c)  ( _ctype[c] & __ISDIGIT )
      #define isgraph(c)  ( _ctype[c] & __ISGRAPH )
      #define islower(c)  ( _ctype[c] & __ISLOWER )
      #define isprint(c)  ( _ctype[c] & __ISPRINT )
      #define ispunct(c)  ( _ctype[c] & __ISPUNCT )
      #define isspace(c)  ( _ctype[c] & __ISSPACE )
      #define isupper(c)  ( _ctype[c] & __ISUPPER )
      #define isxdigit(c) ( _ctype[c] & __ISXDIGIT )
      #define tolower(c)  ( _tolowtbl[c] )
      #define toupper(c)  ( _toupptbl[c] )
   #endif

   #if (__IBMC__ || __IBMCPP__) && __LIBANSI__
      #pragma isolated_call(isalnum)
      #pragma isolated_call(isalpha)
      #pragma isolated_call(iscntrl)
      #pragma isolated_call(isdigit)
      #pragma isolated_call(isgraph)
      #pragma isolated_call(islower)
      #pragma isolated_call(isprint)
      #pragma isolated_call(ispunct)
      #pragma isolated_call(isspace)
      #pragma isolated_call(isupper)
      #pragma isolated_call(isxdigit)
      #pragma isolated_call(tolower)
      #pragma isolated_call(toupper)
   #endif

   #if __EXTENDED__
      int _LNK_CONV _tolower(int);
      int _LNK_CONV _toupper(int);
      int _LNK_CONV _isascii(int);
      int _LNK_CONV _iscsymf(int);
      int _LNK_CONV _iscsym(int);
      int _LNK_CONV _toascii(int);

      #define _tolower(c) ((c) + 'a' - 'A')
      #define _toupper(c) ((c) + 'A' - 'a')
      #define _isascii(c) ((unsigned)(c) < 0x80)
      #define _iscsymf(c) (isalpha(c) || (c) == '_')
      #define _iscsym(c)  (isalnum(c) || (c) == '_')
      #define _toascii(c) ((c) & 0x7f)

      #if __cplusplus
         inline int isascii(int __c) { return _isascii(__c); }
         inline int iscsymf(int __c) { return _iscsymf(__c); }
         inline int iscsym (int __c) { return _iscsym (__c); }
         inline int toascii(int __c) { return _toascii(__c); }
         inline int isblank(int __c) { return _ctype[(__c)] & __ISBLANK; }
      #else
         extern int _IMPORT _LNK_CONV isblank(int);
         #define  isascii(c)        _isascii(c)
         #define  iscsymf(c)        _iscsymf(c)
         #define  iscsym(c)         _iscsym(c)
         #define  toascii(c)        _toascii(c)
         #define  isblank(c)  (_ctype[c] & __ISBLANK)
      #endif
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

