#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )

#ifndef __fstream_h
   #define __fstream_h

   /********************************************************************/
   /*  <fstream.h> header file                                         */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /*                                                                  */
   /*                                                                  */
   /*  Licensed Materials - Property of USL                            */
   /*                                                                  */
   /*  Standard Class Library Version 3.0                              */
   /*  Copyright (C) Unix System Laboratories Inc. 1991.               */
   /*  All rights reserved                                             */
   /*                                                                  */
   /********************************************************************/

   /**************************************************************************/
   /*  C++ source for the C++ Language System, Release 3.0.  This product    */
   /*  is a new release of the original cfront developed in the computer     */
   /*  science research center of AT&T Bell Laboratories.                    */
   /*                                                                        */
   /*  Copyright (c) 1991 AT&T and UNIX System Laboratories, Inc.            */
   /*  Copyright (c) 1984, 1989, 1990 AT&T.  All Rights Reserved.            */
   /*                                                                        */
   /*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE of AT&T and UNIX System   */
   /*  Laboratories, Inc.  The copyright notice above does not evidence      */
   /*  any actual or intended publication of such source code.               */
   /*                                                                        */
   /*  UNIX is a registered trademark of UNIX System Laboratories, Inc.      */
   /*                                                                        */
   /*  ident "@(#)ctrans:incl-master/const-headers/fstream.h 1.4"            */
   /**************************************************************************/

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   #include <iostream.h>

   #pragma pack(4)

   class _IMPORT filebuf : public streambuf {     /* a stream buffer for files */
   public:
           static const int openprot ; /* default protection for open */
   public:
                           filebuf() ;
                           filebuf(int fd);
                           filebuf(int fd, char*  p, int l) ;

           int             is_open() { return opened ; }
           int             fd() { return xfd ; }
           filebuf*        open(const char *name, int om, int prot=openprot);
           filebuf*        attach(int fd) ;
           int             detach();
           filebuf*        close() ;
                           ~filebuf() ;
   public: /* virtuals */
           virtual int     overflow(int=EOF);
           virtual int     underflow();
           virtual int     sync() ;
           virtual streampos
                           seekoff(streamoff,ios::seek_dir,int) ;
           virtual streambuf*
                           setbuf(char*  p, int len) ;
   protected:
           int             xfd;
           int             mode ;
           char            opened;
           streampos       last_seek ;
           char*           in_start;
           int             last_op();
           char            lahead[2] ;
   };

   class _IMPORT fstreambase : virtual public ios {
   public:
                           fstreambase() ;

                           fstreambase(const char* name,
                                           int mode,
                                           int prot=filebuf::openprot) ;
                           fstreambase(int fd) ;
                           fstreambase(int fd, char*  p, int l) ;
                           ~fstreambase() ;
           void            open(const char* name, int mode,
                                           int prot=filebuf::openprot) ;
           void            attach(int fd);
           int             detach();
           void            close() ;
           void            setbuf(char*  p, int l) ;
           filebuf*        rdbuf() { return &buf ; }
   private:
           filebuf         buf ;
   protected:
           void            verify(int) ;
   } ;

   class _IMPORT ifstream : public fstreambase, public istream {
   public:
                           ifstream() ;
                           ifstream(const char* name,
                                           int mode=ios::in,
                                           int prot=filebuf::openprot) ;
                           ifstream(int fd) ;
                           ifstream(int fd, char*  p, int l) ;
                           ~ifstream() ;

           filebuf*        rdbuf() { return fstreambase::rdbuf(); }
           void            open(const char* name, int mode=ios::in,
                                           int prot=filebuf::openprot) ;
   } ;

   class _IMPORT ofstream : public fstreambase, public ostream {
   public:
                           ofstream() ;
                           ofstream(const char* name,
                                           int mode=ios::out,
                                           int prot=filebuf::openprot) ;
                           ofstream(int fd) ;
                           ofstream(int fd, char*  p, int l) ;
                           ~ofstream() ;

           filebuf*        rdbuf() { return fstreambase::rdbuf(); }
           void            open(const char* name, int mode=ios::out,
                                           int prot=filebuf::openprot) ;
   } ;

   class _IMPORT fstream : public fstreambase, public iostream {
   public:
                           fstream() ;

                           fstream(const char* name,
                                           int mode,
                                           int prot=filebuf::openprot) ;
                           fstream(int fd) ;
                           fstream(int fd, char*  p, int l) ;
                           ~fstream() ;
           filebuf*        rdbuf() { return fstreambase::rdbuf(); }
           void            open(const char* name, int mode,
                                   int prot=filebuf::openprot) ;
   } ;

   #pragma pack()

#endif

#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )

