// Revision: 67 1.6.2.1 source/albert/graph2d/i2dghand.inl, 2d, ioc.v400, 001006 
#ifndef _I2DGHAND_INL_
#define _I2DGHAND_INL_
/*----------------------------------------------------------------------------*/
/* FILE NAME: i2dghand.inl                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains the definition of the inline functions for the        */
/*   classes declared in i2dghand.hpp.                                        */
/*                                                                            */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   ????-???                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997                                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
| IPointerHandle::asUnsigned                                                   |
------------------------------------------------------------------------------*/
inline unsigned long IPointerHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IPointerHandle::operator Value ( ) const
{
  return this->fhandle;
}

#ifndef IC_PM
/*------------------------------------------------------------------------------
| IPresSpaceHandle::IPresSpaceHandle                                           |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIF
inline IPresSpaceHandle::IPresSpaceHandle ( Value value,
                                            INativeWindowHandle )
  : fhandle( value )
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
inline IPresSpaceHandle::IPresSpaceHandle ( Value value,
                                            INativeWindowHandle )
  : fhandle( value )
  #else
inline IPresSpaceHandle::IPresSpaceHandle ( void* value,
                                            INativeWindowHandle )
  : fhandle( (Value) value )
  #endif
 #else
inline IPresSpaceHandle::IPresSpaceHandle ( Value value,
                                            INativeWindowHandle )
  : fhandle( value )
 #endif
#endif // IC_WIN
{
}

inline unsigned long IPresSpaceHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IPresSpaceHandle::operator Value ( ) const
{
  return this->fhandle;
}
#endif // IC_PM

/*------------------------------------------------------------------------------
| IBitmapHandle::asUnsigned                                                    |
------------------------------------------------------------------------------*/
inline unsigned long IBitmapHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IBitmapHandle::operator Value ( ) const
{
  return this->fhandle;
}

/*------------------------------------------------------------------------------
| IRegionHandle::IRegionHandle                                                 |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIFPM
inline IRegionHandle::IRegionHandle ( Value value )
  : fhandle( value )
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
inline IRegionHandle::IRegionHandle ( Value value )
  : fhandle( value )
  #else
inline IRegionHandle::IRegionHandle ( void* value )
  : fhandle( (Value) value )
  #endif
 #else
inline IRegionHandle::IRegionHandle ( Value value )
  : fhandle( value )
 #endif
#endif // IC_WIN
{
}

inline unsigned long IRegionHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IRegionHandle::operator Value ( ) const
{
  return this->fhandle;
}

#endif // _I2DGHAND_INL_
