//----------------------------------------------------------------------------
// FILE NAME: ibase.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IBase
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 77  1.13.2.9  source/core/base/ibase.hpp, appsupport, ioc.v400, 001006  
//----------------------------------------------------------------------------

#ifndef _IBASE_
#define _IBASE_

#ifdef _MSC_VER
#pragma warning(once : 4068 4237 4103)
#endif

#include <ilanglvl.hpp>
#include <iexcbase.hpp>
#include <istream.hpp>






// ---------------------------- Platform Macros ------------------------------
#ifndef  IC_PM

        #define IC_PM

#endif

















#if defined(IC_PM)
    #define IC_PMWIN
    #define IC_MOTIFPM
#endif











































#if defined(IC_PM_FLAGNOP)
    #define IC_PMWIN_FLAGNOP
    #define IC_MOTIFPM_FLAGNOP
#endif











// ------------------------------ Version Levels ------------------------------





#ifdef IC_PM
#define IC_MAJOR_VERSION 400
#define IC_MINOR_VERSION 100
#endif

















#define IC_OBSOLETE_1    310
#define IC_OBSOLETE_2    400
#define IC_OBSOLETE_3    410

// ----------------------------- Obsolete Levels ------------------------------
#ifndef IC_OBSOLETE




    #ifdef IC_PM
        #define IC_OBSOLETE  400
    #endif












#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )

#ifndef IC_BUILD
class IBase;
inline ostream& IC_EXPORTB operator<<(ostream &aStream, const IBase &anObject);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IBase
{
public:
    // --------------------------- bool Definitions ---------------------------
    #if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
    typedef bool Boolean;
    #endif

    // ------------------------------ Messages --------------------------------
    static char* messageFile( );

    static void setMessageFile ( const char *msgFileName );

    static IMessageText
    messageText(unsigned long messageId,
                const char*   textInsert1 = 0,
                const char*   textInsert2 = 0,
                const char*   textInsert3 = 0,
                const char*   textInsert4 = 0,
                const char*   textInsert5 = 0,
                const char*   textInsert6 = 0,
                const char*   textInsert7 = 0,
                const char*   textInsert8 = 0,
                const char*   textInsert9 = 0 );

    // ------------------------------- Diagnostics ----------------------------
    friend ostream& IC_EXPORTB
    operator <<( ostream &aStream, const IBase &anObject );

    char* asText() const;

    IString asString() const;

    IString asDebugInfo() const;

    struct Version
    {
        unsigned short major;
        unsigned short minor;
    };

    static Version version();

protected:
    // -------------------------- Exception Severity --------------------------
    static const IException::Severity IC_IMPORTB unrecoverable;
    static const IException::Severity IC_IMPORTB recoverable;

private:
    // ------------------------------- Private --------------------------------
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

inline ostream &operator<<(ostream& aStream, const IBase& anObject)
{
    char* pszText = anObject.asText();
    aStream << pszText;
    delete pszText;
    return aStream;
}

#endif // ( IC_OBSOLETE <= IC_OBSOLETE_3 )


// -------------------------- Static Object Priority --------------------------
#define IBASE_PRIORITY -2147483647 - 1 + 1024

// with NLS (wide char) support
#define IC_NLS

// has restartable version
#define IC_HAS_RESTARTABLE

#ifdef _MSC_VER
    #define _System __stdcall
    #define _Optlink __fastcall
#endif


























































// ----------------------- Functions Excluded from Documentation --------------
#ifndef _ISYNONYM_
#include <isynonym.hpp>
#endif


#  ifdef _MSC_VER
#    ifndef _MT
#      error Error: Use of IBM Open Class Library requires the /MD compiler option. Check the makefile (or its profile) for a missing /MD option.
#    endif
#  else // ! _MSC_VER
#    ifndef __MULTI__
#      if __IBMCPP__ >= 400
#        error Error: Use of IBM Open Class Library requires the "link(linkWithMultithreadLib, yes)" option.
#      else // __IBMCPP__ < 400
#        error Error: Use of IBM Open Class Library requires the /Gm+ compiler option. Check the makefile (or its profile) for a missing /Gm+ option.
#      endif // __IBMCPP__ >= 400
#    endif // __MULTI__
#  endif // _MSC_VER















#endif // _IBASE_
