// Revision: 35 1.25 source/ui/basectl/icanvas.hpp, canvas, ioc.v400, 001006 
#ifndef _ICANVAS_
  #define _ICANVAS_
/*******************************************************************************
* FILE NAME: icanvas.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICanvas                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <ihandle.hpp>
#include <inotifev.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <itext.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICanvasData;
class ICanvasHandler;
class IColor;
class IEvent;
class IFont;
class IResourceId;
class IWindowPosBuffer;

struct HWND__;

#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
extern "C" {
  extern void* __stdcall _pfnwpICCanProc ( struct HWND__*,
                                           unsigned long,
                                           void*,
                                           void* );
 #else
extern "C" {
  extern void* __stdcall _pfnwpICCanProc ( void*,
                                           unsigned long,
                                           void*,
                                           void* );
 #endif
}
#endif
#ifdef IC_PM
extern "C" {
  extern void* _System _pfnwpICCanProc ( unsigned long,
                                         unsigned long,
                                         void*,
                                         void* );
}
#endif

#pragma enum(4)
#pragma pack(push,4)

class ICanvas : public IControl {
typedef IControl
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  ICanvas ( unsigned long     windowIdentifier,
            IWindow*          parent,
            IWindow*          owner,
            const IRectangle& initial = IRectangle(),
            const Style&      style = defaultStyle() );
virtual
 ~ICanvas ( );

/*---------------------------------- Style -----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, ICanvas, IWindow);
static const Style
  IC_IMPORTU border,
  IC_IMPORTU classDefaultStyle;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*------------------------------ Border and Text -----------------------------*/
virtual ICanvas
 &addBorder               ( ),
 &removeBorder            ( ),
 &setBorderText           ( const IText&       borderText,
                            bool               showBorder = true ),
 &setBorderText           ( const IResourceId& borderText,
                            bool               showBorder = true );
virtual bool
  hasBorder               ( ) const;
IText
  borderText              ( ) const;
IPoint
  topLeftLayoutOffset     ( ) const,
  bottomRightLayoutOffset ( ) const;

/*---------------------------------- Colors ----------------------------------*/
#ifndef IC_MOTIF
virtual IColor
  backgroundColor    ( ) const;
#endif
virtual IColor
  borderColor        ( ) const;
virtual ICanvas
 &setBorderColor     ( const IColor& borderColor ),
 &resetBorderColor   ( );

/*------------------------------ Font Functions ------------------------------*/
#ifdef IC_MOTIFWIN
virtual ICanvas
 &setFont   ( const IFont& font );
#endif

#ifdef IC_WIN
virtual ICanvas
 &resetFont ( );
#endif

#ifdef IC_MOTIF
virtual IFont
  font      ( ) const;
#endif

/*------------------------- Dialog Behavior Support --------------------------*/
virtual bool
  isTabStop        ( ) const;
virtual IWindowHandle
  matchForMnemonic ( unsigned short character ) const;

/*------------------------------ Layout Support ------------------------------*/
virtual bool
  hasChildrenToLayout ( ) const;
virtual ICanvas
 &setLayoutDistorted  ( unsigned long layoutAttributesOn,
                        unsigned long layoutAttributesOff );

/*--------------------------- Notification Members ---------------------------*/
static INotificationId const
  IC_IMPORTU textId;

protected:
/*------------------------------- Constructors -------------------------------*/
  ICanvas ( );

/*------------------------------ Layout Support ------------------------------*/
virtual ICanvas
 &layout              ( );
ISize
  layoutSize          ( ) const;
ICanvas
 &setLayoutSize       ( const ISize& size );
virtual IWindowPosBuffer
  fixupChildren       ( );
bool
  areChildrenReversed ( ) const;
virtual ISize
  calcMinimumSize     ( ) const;

/*------------------------------ Border and Text -----------------------------*/
IRectangle
  rectangleInsideBorder ( const ISize& sizeWithBorder ) const;
ISize
  sizeWithBorder        ( const ISize& sizeWithoutBorder ) const;

/*------------------------ Constructor Implementation ------------------------*/
ICanvas
 &initialize ( unsigned long     windowIdentifier,
               IWindow*          parent,
               IWindow*          owner,
               const IRectangle& initialRect,
               unsigned long     style,
               unsigned long     extendedStyle );

#ifdef IC_MOTIF
/*---------------------- Event-Handling Implementation -----------------------*/
virtual bool
  passEventToOwner ( IEvent &event );
#endif

#ifdef IC_PMWIN
/*---------------------- Bidirectional Language Support ----------------------*/
virtual ICanvas
 &setBidiSettings ( const IBidiSettings& bidiSettings,
                    bool                 childInherit,
                    bool                 refresh );
#endif

private:
/*----------------------------- Hidden Members -------------------------------*/
  ICanvas   ( const ICanvas& canvas );
ICanvas
 &operator= ( const ICanvas& canvas );

#ifdef IC_MOTIF
virtual void
  registerCallbacks   ( ),
  unregisterCallbacks ( );
#endif

/*--------------------------------- Private ----------------------------------*/
#ifdef IC_MOTIF
friend class ICanvasHandler;
#endif
#ifdef IC_PM
friend void* _System
  _pfnwpICCanProc ( unsigned long hwnd,
                    unsigned long ulMsg,
                    void*         mp1,
                    void*         mp2 );
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
friend void* __stdcall
  _pfnwpICCanProc ( struct HWND__* hwnd,
                    unsigned long  ulMsg,
                    void*          mp1,
                    void*          mp2 );
 #else
friend void* __stdcall
  _pfnwpICCanProc ( void*         hwnd,
                    unsigned long ulMsg,
                    void*         mp1,
                    void*         mp2 );
 #endif
#endif // IC_WIN

static Style
  currentDefaultStyle;
bool
  paintWindow            ( const IEvent& event );
ISize
  borderMargin           ( ) const;
unsigned long
  borderThickness        ( ) const;
IColor
  defaultBorderTextColor ( ) const;
IText
  stylizedBorderText     ( ) const;
bool
  isClassStyleAllPaints  ( ) const;
ISize
  sizClLayout;
bool
  bClChildrenReversed,
  bClDefaultHandlerAdded;
IFont
 *fFont;
IText
  fBorderText;
IColor
 *fBorderColor;
ICanvasData
 *fCanvasData;

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
/*------------------------- Dialog Behavior Support --------------------------*/
IWindowHandle
  origDefaultButtonHandle ( ) const;
virtual IWindowHandle
  defaultPushButton       ( ) const;
#endif // IC_OBSOLETE
}; // ICanvas

INESTEDBITFLAGCLASSFUNCS(Style, ICanvas)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icanvas.inl>

#endif /* _ICANVAS_ */
