// Revision: 48 1.9.1.5 source/ui/basectl/icolobsv.hpp, listctls, ioc.v400, 001006 
#ifndef _ICOLOBSV_
  #define _ICOLOBSV_
/*******************************************************************************
* FILE NAME: icolobsv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionObserver                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <iobservr.hpp>
#include <iseq2.h>
#include <ilanglvl.hpp>

#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element> class IPartOrderedCollection;
template <class Element, class ViewClass, class Collection> class ICollectionViewData;
class   ICollectionObserverData;

#pragma enum(4)
#pragma pack(push,4)

template <class Element, class ViewClass, class Collection>
  class ICollectionObserver : public IObserver {

typedef IObserver
  Inherited;

public:

/*------------------------- Constructors -------------------------------------*/
  ICollectionObserver ( );

  ICollectionObserver ( const ICollectionObserver<Element,ViewClass,Collection>& source );

virtual
 ~ICollectionObserver ( );

/*------------------------- View and Collection ------------------------------*/
virtual ViewClass
 *viewer        (  ) const;

virtual ICollectionObserver<Element,ViewClass,Collection>
 &setViewer     ( ViewClass*  viewer );

virtual IPartOrderedCollection<Element>
 *collection    (  ) const;

virtual ICollectionObserver<Element,ViewClass,Collection>
 &setCollection ( IPartOrderedCollection<Element>* collection );


private:
/*------------------------- Hidden Members -----------------------------------*/
ICollectionObserver<Element,ViewClass,Collection>
 &operator=           ( const ICollectionObserver<Element,ViewClass,Collection>& source );


/*------------------------- Notification Members -----------------------------*/
virtual IObserver
 &dispatchNotificationEvent ( const INotificationEvent& event );

class ElementObserver : public IObserver {

typedef IObserver
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  ElementObserver ( ViewClass*     viewer,
                    Element        element,
                    unsigned long  position );
  ElementObserver ( const ElementObserver&  source );

virtual
 ~ElementObserver ( );

/*------------------------- Operators ----------------------------------------*/
virtual ElementObserver
 &operator=       ( const ElementObserver & source );


/*------------------------- Element ------------------------------------------*/
virtual Element
  element      ( ) const;
virtual ElementObserver
 &setElement   ( const Element  element );
virtual unsigned long
  position     ( ) const;
virtual ElementObserver
 &setPosition  ( unsigned long  position );


protected:

/*------------------------- Notification Members -----------------------------*/
virtual IObserver
 &dispatchNotificationEvent ( const INotificationEvent& event );

private:

ViewClass
 *fInterestedParty;
Element
  fElement;
unsigned long
  fPosition;


};  // end of ElementObserver


ViewClass
 *fReportTo;
IPartOrderedCollection<Element>
 *fCollection;
IVPtrSequence<ElementObserver *>
  fElementObservers;
TYPENAME IVPtrSequence<ElementObserver *>::Cursor
  fCursor;
ICollectionObserverData
 *fCollectionObserverData;

void
  deleteAllElementObservers ( );

}; // ICollectionObserver

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if ! defined(__TEMPINC__)
#include <icolobsv.c>
#endif

#endif  /*  _ICOLOBSV_  */
