// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 03 1.6.1.4 source/core/collect/iibagdil.h, collection, ioc.v400, 001006 
#ifndef _IIBAGDIL_
#define _IIBAGDIL_

#include <iibagkb.h>
#include <iikbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IBagOnKeyBagImpl
         <IKeyBagAsDilTableImpl> IBagAsDilTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsDilTableImpl> IABagAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IBagAsDilTableOps :
  public IABagAsDilTableOps {

  typedef  IABagAsDilTableOps Inherited;

  typedef  IBagAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsDilTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsDilTableOps
                           (INumber);

           IBagAsDilTableOps
                           (INumber, void*);

           IBagAsDilTableOps
                           (IBagAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iibagdil.c>
#endif



#pragma info (restore)


#endif // _IIBAGDIL_
