// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 74 1.6.1.4 source/core/collect/iihptab.h, collection, ioc.v400, 001006 
#ifndef _IIHPTAB_
#define _IIHPTAB_

#include <iihpseq.h>
#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IHeapOnSequenceImpl
         <ISequenceAsTableImpl> IHeapAsTableImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsTableImpl> IAHeapAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IHeapAsTableOps :
  public IAHeapAsTableOps {

  typedef  IHeapAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsTableOps
                           (INumber);

           IHeapAsTableOps
                           (INumber, void*);

           IHeapAsTableOps
                           (IHeapAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();



















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iihptab.c>
#endif



#pragma info (restore)


#endif // _IIHPTAB_
