// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 95 1.6.3.1 source/core/collect/iiksavl.h, collection, ioc.v400, 001006 
#ifndef _IIKSAVL_
#define _IIKSAVL_

#include <iikskss.h>
#include <iikssavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsAvlTreeImpl> IKeySetAsAvlTreeImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsAvlTreeImpl> IAKeySetAsAvlTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsAvlTreeOps :
  public IAKeySetAsAvlTreeOps {

  typedef  IKeySetAsAvlTreeOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, Key,
             ElementOps, IKeySortedSetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsAvlTreeOps
                           (INumber);

           IKeySetAsAvlTreeOps
                           (INumber, void*);

           IKeySetAsAvlTreeOps
                           (IKeySetAsAvlTreeOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif









#ifndef IC_BUILD
#include <iiksavl.c>
#else
#if ! defined (__TEMPINC__)
#include <iiksavl.c>
#endif
#endif




#pragma info (restore)


#endif // _IIKSAVL_
