// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 10 1.6.1.4 source/core/collect/iiksbtab.h, collection, ioc.v400, 001006 
#ifndef _IIKSBTAB_
#define _IIKSBTAB_

#include <iiksbseq.h>
#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySortedBagOnSequenceImpl
         <ISequenceAsTableImpl> IKeySortedBagAsTableImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySortedBagAsTableOps :
  public IAKeySortedBagOnSequenceOps <ISequenceAsTableImpl> {

  typedef  IKeySortedBagAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedBagAsTableOps
                           (INumber);

           IKeySortedBagAsTableOps
                           (INumber, void*);

           IKeySortedBagAsTableOps
                           (IKeySortedBagAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiksbtab.c>
#endif



#pragma info (restore)


#endif // _IIKSBTAB_
