// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 16 1.6.3.1 source/core/collect/iikshsh.h, collection, ioc.v400, 001006 
#ifndef _IIKSHSH_
#define _IIKSHSH_

#include <iikskb.h>
#include <iikbhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeyBagImpl
         <IKeyBagAsHshTableImpl> IKeySetAsHshTableImpl;

typedef IAKeySetOnKeyBagOps
         <IKeyBagAsHshTableImpl> IAKeySetAsHshTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsHshTableOps :
  public IAKeySetAsHshTableOps {

  typedef  IKeySetAsHshTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableOps
            <Element, _Key,
             ElementOps, IKeyBagAsHshTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySetAsHshTableOps
                           (INumber);

           IKeySetAsHshTableOps
                           (INumber, void*);

           IKeySetAsHshTableOps
                           (IKeySetAsHshTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsHshTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsHshTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif









#ifndef IC_BUILD
#include <iikshsh.c>
#else
#if ! defined (__TEMPINC__)
#include <iikshsh.c>
#endif
#endif




#pragma info (restore)


#endif // _IIKSHSH_
