// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 51 1.6.1.4 source/core/collect/iimapavl.h, collection, ioc.v400, 001006 
#ifndef _IIMAPAVL_
#define _IIMAPAVL_

#include <iimapks.h>
#include <iiksavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IMapOnKeySetImpl
         <IKeySetAsAvlTreeImpl> IMapAsAvlTreeImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsAvlTreeImpl> IAMapAsAsAvlTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IMapAsAvlTreeOps :
  public IAMapAsAsAvlTreeOps {

  typedef  IMapAsAvlTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsAvlTreeOps
            <Element, _Key,
             ElementOps, IKeySetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsAvlTreeOps
                           (INumber);

           IMapAsAvlTreeOps
                           (INumber, void*);

           IMapAsAvlTreeOps
                           (IMapAsAvlTreeOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements    (void const*, void const*) const;

           operator IKeySetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iimapavl.c>
#endif



#pragma info (restore)


#endif // _IIMAPAVL_
