// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 03 1.5.1.5 source/core/collect/iiseqdil.h, collection, ioc.v400, 001006 
#ifndef _IISEQDIL_
#define _IISEQDIL_

#include <iiaseq.h>
#include <iitable.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum (4)
#pragma pack (push,4)

template <class Element>
struct ISequenceAsDilTableNodeImpl {

  void*    ivPtr;

  Element  ivElement;

           ISequenceAsDilTableNodeImpl
                            (Element const&);

          ~ISequenceAsDilTableNodeImpl
                            ();

#if !defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif







};

struct IDilTableImpl : public ITableImpl {

  typedef  ISequenceAsDilTableNodeImpl <void*> Node;

  typedef struct {
    void *unused;
    size_t offset;
  } UnusedOffset;

  UnusedOffset* ivUnused;

  void*    ElementAtIndex   (INumber) const;

  void     GetUnused        (INumber);

  void*&   PtrAtIndex       (INumber) const;

  void     PutUnused        (INumber);

  void     RemoveAtIndex    (INumber);

};










class IC_EXPORTC ISequenceAsDilTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsDilTableCursorImpl Self;

public:

           ISequenceAsDilTableCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsDilTableCursorImpl
                            (ISequenceAsDilTableCursorImpl const&);

          ~ISequenceAsDilTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  bool IsInBetween      () const;

  bool IsValid          () const;

  void     operator=        (ISequenceAsDilTableCursorImpl const&);

  bool operator==       (ICursorImpl const&) const;

protected:

private:

  INumber  ivIndex;

  friend
  class    ISequenceAsDilTableImpl;










};




























































class IASequenceAsDilTableOps;

class IC_EXPORTC ISequenceAsDilTableImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsDilTableImpl Self;

public:

  typedef  IASequenceAsDilTableOps Ops;

  typedef  ISequenceAsDilTableCursorImpl Cursor;




  typedef  ISequenceAsDilTableCursorImpl MngCursor;


           ISequenceAsDilTableImpl
                            (Ops&, INumber);

           ISequenceAsDilTableImpl
                            (Ops&, ISequenceAsDilTableImpl const&);

          ~ISequenceAsDilTableImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition position, void const*);

  void     Reverse          ();

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsDilTableImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  IDilTableImpl
           ivTable;

  virtual
  void     CopyFrom         (ISequenceAsDilTableImpl const&);

  void*    ElementOf        (void const*) const;

  void     GrowBy           (INumber);

  static
  INumber& IndexOf          (ICursorImpl const&);

  void     Initialize       (INumber);

  static
  bool IsInBetween      (ICursorImpl const&);

  bool IsRemoved        (INumber) const;

  void     MakeFree         (INumber&);

  static
  INumber& NextIndexOf      (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsDilTableImpl const&);

  IPosition
           PositionAtIndex  (INumber) const;

  static
  INumber& PreviousIndexOf  (ICursorImpl const&);

  void     RemoveAtIndex    (INumber);

  void     SetInBetween     (MngCursor&) const;

  bool SetToNextIndex   (INumber&) const;

  bool SetToPreviousIndex
                            (INumber&) const;

  void     UpdateMngCursorsForCopyFrom
                            (INumber, INumber) const;

  void     UpdateMngCursorsForGrowBy
                            () const;

  void     UpdateMngCursorsForRemoveOf
                            (INumber) const;

  void     UpdateMngCursorsForSwap
                            (INumber, INumber) const;

  friend
  class    ISequenceAsDilTableMngCursorImpl;

#if ! defined (__INO_STREAMING__)
protected:
  void     AddAsLastFromStreamer
                            (IDataStream&, ICursorImpl&);

  void     ConstructNodeWithStreamer
                            (void*, IDataStream&) const;

public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif














































};

class IC_EXPORTC IASequenceAsDilTableOps {
public:

  virtual ~IASequenceAsDilTableOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&, size_t&) const = 0;

  virtual
  void     ConstructNode    (void*, void const*) const = 0;

  virtual
  void     DeleteNodes      (void*) const = 0;

  virtual
  void     DestroyNode      (void*) const = 0;

protected:

           IASequenceAsDilTableOps
                            (bool);

private:

  bool ivContainsDTSObjects;

  friend
  class    ISequenceAsDilTableImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void     ConstructNodeWithStreamer
                         (void*, IACollectionStreamer*, IDataStream&) const = 0;
#endif
















};

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISequenceAsDilTableOps : public IASequenceAsDilTableOps {

  typedef  IASequenceAsDilTableOps Inherited;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsDilTableOps
                            (INumber);

           ISequenceAsDilTableOps
                            (INumber, void*);

           ISequenceAsDilTableOps
                            (ISequenceAsDilTableOps
                              <Element, ElementOps,
                               Implementation> const&);

          ~ISequenceAsDilTableOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNodes      (INumber, size_t&, size_t&) const;

  void     ConstructNode    (void*, void const*) const;

  void     DeleteNodes      (void*) const;

  void     DestroyNode      (void*) const;

           operator Implementation*
                            ();



















protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
public:
  void     ConstructNodeWithStreamer
                            (void*, IACollectionStreamer*, IDataStream&) const;
#endif












};

#pragma pack (pop)
#pragma enum (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iiseqdil.inl>




#if ! defined (__TEMPINC__)
#include <iiseqdil.c>
#endif


#endif // _IISEQDIL_
