// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 07 1.5.1.4 source/core/collect/iiseqlst.h, collection, ioc.v400, 001006 
#ifndef _IISEQLST_
#define _IISEQLST_

#include <iiaseq.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element>
struct ISequenceAsListNodeImpl;

#pragma enum (4)
#pragma pack (push,4)

template <class Element>
struct ISequenceAsListNodeImpl {

  ISequenceAsListNodeImpl <Element>
          *ivNext,
          *ivPrevious;

  Element  ivElement;

           ISequenceAsListNodeImpl
                            (Element const&);

          ~ISequenceAsListNodeImpl
                            ();

#if ! defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif







};










class IC_EXPORTC ISequenceAsListCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsListCursorImpl Self;

public:

           ISequenceAsListCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsListCursorImpl
                            (ISequenceAsListCursorImpl const&);

          ~ISequenceAsListCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  bool IsInBetween      () const;

  bool IsValid          () const;

  void     operator=        (ISequenceAsListCursorImpl const&);

  bool operator==       (ICursorImpl const&) const;

protected:

private:

  ISequenceAsListNodeImpl <long>*
           ivNode;

  friend
  class    ISequenceAsListImpl;










};






























































class IASequenceAsListOps;

class IC_EXPORTC ISequenceAsListImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsListImpl Self;

  typedef  ISequenceAsListNodeImpl <long> Node;

public:

  typedef  IASequenceAsListOps Ops;

  typedef  ISequenceAsListCursorImpl Cursor;




  typedef  ISequenceAsListCursorImpl MngCursor;


           ISequenceAsListImpl
                            (Ops&, INumber);

           ISequenceAsListImpl
                            (Ops&,
                             ISequenceAsListImpl const&);

          ~ISequenceAsListImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsListImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;


private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  Node*    ivFirst;

  Node*    ivLast;

  INumber  ivNumberOfElements;

  void     AddAsNextNode    (Node*, Node*);

  void*    ElementOf        (Node const*) const;

  static
  bool IsInBetween      (ICursorImpl const&);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsListImpl const&);

  static
  Node*&   PreviousNodeOf   (ICursorImpl const&);

  void     RemoveNode       (Node*);

  void     SetInBetween     (MngCursor&) const;

  void     SetNodeToPosition
                            (IPosition, Node*&) const;

  friend
  class    ISequenceAsListMngCursorImpl;

#if ! defined (__INO_STREAMING__)
protected:
  void*    CreateNodeWithStreamer
                              (IDataStream&) const;

public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif






























};

class IC_EXPORTC IASequenceAsListOps {
public:

  virtual ~IASequenceAsListOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;


protected:

           IASequenceAsListOps
                            (bool);

private:

  bool ivContainsDTSObjects;

  friend
  class    ISequenceAsListImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*,
                             IDataStream&) const = 0;
#endif














};

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISequenceAsListOps : public IASequenceAsListOps {

  typedef  IASequenceAsListOps Inherited;

  typedef  ISequenceAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsListOps
                            (INumber);

           ISequenceAsListOps
                            (INumber, void*);

           ISequenceAsListOps
                            (ISequenceAsListOps
                              <Element, ElementOps,
                               Implementation> const&);

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

           operator Implementation*
                            ();



















protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
public:
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*, IDataStream&) const;
#endif












};

#pragma enum (pop)
#pragma pack (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iiseqlst.inl>





#ifndef IC_BUILD
#include <iiseqlst.c>
#else
#if ! defined (__TEMPINC__)
#include <iiseqlst.c>
#endif
#endif



#endif // _IISEQLST_
