// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 15 1.6.3.1 source/core/collect/iisetavl.h, collection, ioc.v400, 001006 
#ifndef _IISETAVL_
#define _IISETAVL_

#include <iisetks.h>
#include <iiksavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISetOnKeySetImpl
         <IKeySetAsAvlTreeImpl> ISetAsAvlTreeImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISetAsAvlTreeOps :
  public IASetOnKeySetOps <IKeySetAsAvlTreeImpl> {

  typedef  ISetAsAvlTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySetAsAvlTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISetAsAvlTreeOps
                           (INumber);

           ISetAsAvlTreeOps
                           (INumber, void*);

           ISetAsAvlTreeOps
                           (ISetAsAvlTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif









#ifndef IC_BUILD
#include <iisetavl.c>
#else
#if ! defined (__TEMPINC__)
#include <iisetavl.c>
#endif
#endif




#pragma info (restore)


#endif // _IISETAVL_
