// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 36 1.6.1.5 source/core/collect/iismavl.h, collection, ioc.v400, 001006 
#ifndef _IISMAVL_
#define _IISMAVL_

#include <iismkss.h>
#include <iikssavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedMapOnKeySortedSetImpl
         <IKeySortedSetAsAvlTreeImpl> ISortedMapAsAvlTreeImpl;

typedef IASortedMapOnKeySortedSetOps
         <IKeySortedSetAsAvlTreeImpl> IASortedMapAsAvlTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedMapAsAvlTreeOps :
  public IASortedMapAsAvlTreeOps {

  typedef  ISortedMapAsAvlTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, _Key,
             ElementOps, IKeySortedSetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedMapAsAvlTreeOps
                           (INumber);

           ISortedMapAsAvlTreeOps
                           (INumber, void*);

           ISortedMapAsAvlTreeOps
                           (ISortedMapAsAvlTreeOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedMapAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedSetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif









#ifndef IC_BUILD
#include <iismavl.c>
#else
#if ! defined (__TEMPINC__)
#include <iismavl.c>
#endif
#endif




#pragma info (restore)


#endif // _IISMAVL_
