// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 51 1.6.1.4 source/core/collect/iismtab.h, collection, ioc.v400, 001006 
#ifndef _IISMTAB_
#define _IISMTAB_

#include <iismkss.h>
#include <iiksstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedMapOnKeySortedSetImpl
         <IKeySortedSetAsTableImpl> ISortedMapAsTableImpl;

typedef IASortedMapOnKeySortedSetOps
         <IKeySortedSetAsTableImpl> IASortedMapAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedMapAsTableOps :
  public IASortedMapAsTableOps {

  typedef  ISortedMapAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsTableOps
            <Element, _Key,
             ElementOps, IKeySortedSetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedMapAsTableOps
                           (INumber);

           ISortedMapAsTableOps
                           (INumber, void*);

           ISortedMapAsTableOps
                           (ISortedMapAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedMapAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedSetAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iismtab.c>
#endif



#pragma info (restore)


#endif // _IISMTAB_
