// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 20 1.6.1.4 source/core/collect/iivss.h, collection, ioc.v400, 001006 
#ifndef _IIVSS_
#define _IIVSS_

#include <ilanglvl.hpp>
#include <iiass.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSortedSetImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSortedSetImpl
                            (Ops&, INumber);

           IVSortedSetImpl
                            (Ops&, IVSortedSetImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddDifference    (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddIntersection  (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     AddUnion         (IASortedSetImpl const&,
                             IASortedSetImpl const&);

  void     Antivalence      (IASortedSetImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedSetImpl const&);

  void     Intersection     (IASortedSetImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASortedSetImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivss.c>
#endif



#pragma info (restore)


#endif // _IIVSS_
