// Revision: 92 1.9.1.9 source/ui/basectl/ilistbas.hpp, listctls, ioc.v400, 001006 
#ifndef _ILISTBAS_
  #define _ILISTBAS_
/*******************************************************************************
* FILE NAME: ilistbas.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseListBox                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IResourceId;
class IBaseListBoxData;
class IBaseListBoxCursorData;

#pragma enum(4)
#pragma pack(push,4)

class IBaseListBox : public IControl {
typedef IControl
  Inherited;
public:
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IBaseListBox   ( unsigned long        id,
                   IWindow*             parent,
                   IWindow*             owner,
                   const IRectangle&    initial = IRectangle  ( ),
                   const Style&         style   = defaultStyle( ) );

  IBaseListBox   ( unsigned long        id,
                   IWindow*             parent );

  IBaseListBox   ( const IWindowHandle& handle );

virtual
 ~IBaseListBox   ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseListBox, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
#ifdef IC_PMWIN
  IC_IMPORTU drawItem,
#endif
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU multipleSelect,
  IC_IMPORTU extendedSelect;
#ifndef IC_MOTIF_FLAGNOP
static const Style
  IC_IMPORTU noAdjustPosition;
#endif
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle            ( );

static void
  setDefaultStyle         ( const Style&    style );

virtual unsigned long
  convertToGUIStyle       ( const IBitFlag& style,
                            bool         extendedOnly = false ) const;

bool
#ifndef IC_MOTIF_FLAGNOP
  isDrawItem              ( ) const,
#endif
  isHorizontalScroll      ( ) const,
  isMultipleSelect        ( ) const,
  isExtendedSelect        ( ) const;
#ifndef IC_MOTIF_FLAGNOP
bool
  isNoAdjustPosition      ( ) const;
#endif

#ifndef IC_MOTIF_FLAGNOP
virtual IBaseListBox
 &enableDrawItem          ( bool enable = true ),
 &disableDrawItem         ( );
#endif

#ifndef IC_WIN_FLAGNOP
virtual IBaseListBox
 &enableMultipleSelect    ( bool enable = true ),
 &disableMultipleSelect   ( ),
 &enableExtendedSelect    ( bool enable = true ),
 &disableExtendedSelect   ( );
#endif

#ifndef IC_MOTIF_FLAGNOP
virtual IBaseListBox
 &enableNoAdjustPosition  ( bool enable = true ),
 &disableNoAdjustPosition ( );
#endif

/*------------------------- Get and Change Items -----------------------------*/
virtual IString
  itemText                ( unsigned long      index ) const;

virtual IBaseListBox
 &setItemText             ( unsigned long      index,
                            const char*        string ),
 &setItemText             ( unsigned long      index,
                            const IResourceId& string );

virtual IString
  elementAt               ( const Cursor&      cursor ) const;

/*------------------------- Selection ----------------------------------------*/
virtual IBaseListBox
 &select                  ( unsigned long index,
                            bool       select = true ),
 &deselect                ( unsigned long index ),
 &selectAll               ( ),
 &deselectAll             ( );

virtual bool
  isSelected              ( unsigned long index ) const;

virtual unsigned long
  numberOfSelections      ( ) const;

virtual long
  selection               ( ) const;

/*------------------------ Scrolling Members ---------------------------------*/
virtual IBaseListBox
 &setTop                  ( unsigned long index );

virtual unsigned long
  top                     ( ) const;

virtual IBaseListBox
 &scrollToItem            ( unsigned long index );


/*------------------------ Handle Members ------------------------------------*/
virtual IBaseListBox
 &setItemHandle           ( unsigned long index,
                            unsigned long handle );

virtual unsigned long
  itemHandle              ( unsigned long index ) const;

/*------------------------ Search List ---------------------------------------*/
enum SearchType {
  prefix,
  substring,
  exactMatch
};

static const unsigned long
  IC_IMPORTU notFound,
  IC_IMPORTU first;

virtual unsigned long
  locateText              ( const char*   searchString,
                            bool       caseSensitive = true,
                            SearchType    search        = exactMatch,
                            unsigned long index         = first ) const;

/*------------------------- Content ------------------------------------------*/
virtual unsigned long
  count                   ( ) const;

virtual bool
  isEmpty                 ( ) const;

/*------------------------- Item Height --------------------------------------*/
virtual IBaseListBox
 &setItemHeight           ( unsigned long newHeight );

unsigned long
  itemHeight              ( unsigned long index = 0) const;

#ifdef IC_MOTIF
/*------------------------- Window Painting ----------------------------------*/
virtual IWindow
 &show                    ( bool showList = true );
virtual IFont
 font                     ( ) const;
#endif

class Cursor  {
public:
/*------------------------------ Filters --------------------------------*/
enum Filter {
  selectedItems,
  allItems
};

/*---------------------------- Constructors -----------------------------*/
  Cursor                  ( const IBaseListBox& listbox,
                            Filter              type = selectedItems );

virtual
 ~Cursor                  ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual bool
  setToFirst              ( ),
  setToNext               ( ),
  setToPrevious           ( ),
  setToLast               ( ),
  setToIndex              ( unsigned long index );

/*-------------------------- Cursor Validation --------------------------*/
virtual bool
  isValid                 ( ) const;

virtual void
  invalidate              ( );

virtual unsigned long
  asIndex                 ( ) const;

private:
/*-------------------------- Hidden Members -----------------------------*/
  Cursor                  ( const Cursor& cursor );
Cursor
 &operator=               ( const Cursor& cursor );

/*------------------------------- Private -------------------------------*/
const IBaseListBox
 &rlbCl;
unsigned long
  lClCurrent;
Filter
  cursorTypeCl;
unsigned long
  sameValidation;

IBaseListBoxCursorData
 *fCursorData;
}; // IBaseListBox::Cursor

/*------------------------- Color --------------------------------------------*/
#ifdef IC_PMWIN
virtual IColor
  backgroundColor         ( ) const;
#endif
#ifdef IC_MOTIF
virtual IBaseListBox
  &setForegroundColor  ( const IColor &color ),
  &setBackgroundColor  ( const IColor &color );
#endif //IC_MOTIF

/*------------------------- Layout Support -----------------------------------*/
virtual IBaseListBox
#ifdef IC_PMWIN
 &setLayoutDistorted      ( unsigned long layoutAttributesOn,
                            unsigned long layoutAttributesOff ),
#endif
 &setMinimumCharacters    ( unsigned long minimumCharacters ),
 &setMinimumRows          ( unsigned long minimumRows );

unsigned long
  minimumCharacters       ( ) const,
  minimumRows             ( ) const;

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU enterId,
  IC_IMPORTU selectId,
  IC_IMPORTU itemChangedId,
  IC_IMPORTU itemsId,
  IC_IMPORTU extendedSelectChangedId;


virtual IBaseListBox
 &enableNotification      ( bool enable = true );

protected:
/*------------------------- Layout Support -----------------------------------*/
virtual ISize
  calcMinimumSize         ( ) const;

#ifdef IC_MOTIFWIN
/*------------------------- Event-Handling Implementation --------------------*/
virtual bool
  passEventToOwner        ( IEvent &event );
#endif // IC_MOTIFWIN

/*------------------------------- Item Changes -------------------------------*/
unsigned long
  changeCount             ( ) const;

void
  incrementChangeCount    ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IBaseListBox            ( const IBaseListBox& listBox );
IBaseListBox
 &operator=               ( const IBaseListBox& listBox );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseListBox::Cursor;
#ifdef IC_MOTIFWIN
friend class IBaseListHandler;
#endif
#ifdef IC_MOTIF
friend class IListBox;
#endif

#ifdef IC_MOTIF
IBaseListBox
 &wrapIt                  ( const IWindowHandle& handle );
#endif

static Style
  currentDefaultStyle;

unsigned long
  needValidation;

IBaseListBoxData
 *fBaseListBoxData;
}; // IBaseListBox

INESTEDBITFLAGCLASSFUNCS(Style, IBaseListBox)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _ILISTBAS_ */
