// Revision: 01 1.8.1.6 source/ui/basectl/ilistcvw.hpp, listctls, ioc.v400, 001006 
#ifndef _ILISTCVW_
  #define _ILISTCVW_
/*******************************************************************************
* FILE NAME: ilistcvw.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewListBox                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ilistbas.hpp>
#include <istrgen.hpp>
#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IWindowHandle;
template <class Element, class Collection> class ICollectionViewListBoxData;

#pragma define(ISequence <unsigned long > )


#pragma enum(4)
#pragma pack(push,4)

template <class Element, class Collection>
  class ICollectionViewListBox : public IBaseListBox {

typedef IBaseListBox
  Inherited;
#pragma define(ICollectionObserver<Element,ICollectionViewListBox<Element,Collection>,Collection>)

public:
/*------------------------- Constructors -------------------------------------*/
  ICollectionViewListBox ( unsigned long                identifier,
                           IWindow*                     parent,
                           IWindow*                     owner,
                           const IRectangle&            initial = IRectangle( ),
                           const IBaseListBox::Style&   style   =
                              IBaseListBox::defaultStyle( ),
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

  ICollectionViewListBox ( unsigned long                identifier,
                           IWindow*                     parent,
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

  ICollectionViewListBox ( const IWindowHandle&         handle,
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

virtual
 ~ICollectionViewListBox ( );

/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                  ( ) const;

virtual ICollectionViewListBox<Element,Collection>
 &setItems               ( Collection* collection );

/*------------------------- String Generator ---------------------------------*/
virtual IStringGenerator<Element>
 &setStringGenerator     ( const IStringGenerator<Element>& stringGenerator );

virtual IStringGenerator<Element>
 &stringGenerator        ( );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual ICollectionViewListBox<Element,Collection>
 &elementChanged         ( unsigned long   position,
                           const Element&  element  ),
 &elementAdded           ( unsigned long   position,
                           const Element&  element  ),
 &elementDeleted         ( unsigned long   position ),
 &elementsChanged        ( ),
 &collectionReplaced     ( );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual ICollectionViewListBox<Element, Collection>
 &select                     ( unsigned long   collectionPosition,
                               bool         select = true ),
 &deselect                   ( unsigned long   collectionPosition );

virtual Element
  selectedElement            ( ) const;

virtual unsigned long
  selectedCollectionPosition ( );

virtual ICollectionViewListBox<Element, Collection>
 &selectedElements           ( Collection&     elements );

#ifndef IC_WIN_FLAGNOP
virtual ICollectionViewListBox<Element, Collection>
 &enableExtendedSelect       ( bool         extended = true );
#endif

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewListBox
             ( const ICollectionViewListBox< Element, Collection >& source );
ICollectionViewListBox<Element,Collection>
 &operator=  ( const ICollectionViewListBox< Element, Collection >& source );

/*------------------------- Private ------------------------------------------*/
ICollectionViewListBoxData<Element, Collection>
 *fCollectionViewListBoxData;

unsigned long
  insert     ( unsigned long    index,
               const char*      text  ),
  deleteItem ( unsigned long    index );

ICollectionViewListBox<Element, Collection>
 &deleteAll  ( );

}; // ICollectionViewListBox<Element,Collection>

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#if ! defined(__TEMPINC__)
#include <ilistcvw.c>
#endif


#endif  /*  _ILISTCVW_  */
