// Revision: 43 1.10.1.7 source/ui/extapp/itbar.hpp, toolbar, ioc.v400, 001006 
#ifndef _ITBAR_
#define _ITBAR_
/*******************************************************************************
* FILE NAME: itbar.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBar                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <isetcv.hpp>
#include <irect.hpp>
#include <itbarbut.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;
class IPoint;
class IResourceId;
class ISize;
class IString;
class IToolBarContainer;
class IToolBarData;
class IToolBarFrameWindow;
class IToolBarFrameCursorData;
class IToolBarWindowCursorData;

#pragma enum(4)
#pragma pack(push,4)

class IToolBar : public ISetCanvas {
typedef ISetCanvas
  Inherited;
public:
class Style;
/*---------------------------- Tool Bar Location -----------------------------*/
enum Location {
  aboveClient,
  belowClient,
  leftOfClient,
  rightOfClient,
  floating
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  ,
  hidden
#endif // IC_OBSOLETE
};

virtual IToolBar
 &setLocation ( Location location );

Location
  location    ( ) const;

bool
  isMoveValid ( Location newLocation) const;

/*------------------------------- Constructors -------------------------------*/
  IToolBar ( unsigned long       identifier,
             IFrameWindow*       owner,
             Location            location = aboveClient,
             bool                groupWithPreceding = false,
             const Style&        style = defaultStyle() );
  IToolBar ( unsigned long       identifier,
             IToolBar*           precedingToolBar,
             bool                groupWithPreceding = false,
             const Style&        style = defaultStyle() );

virtual
 ~IToolBar ( );

/*---------------------------------- Style -----------------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
INESTEDBITFLAGCLASSDEF3(Style, IToolBar, ISetCanvas, ICanvas, IWindow);
#else
INESTEDBITFLAGCLASSDEF0( Style, IToolBar );
#endif

static const Style
  IC_IMPORTU buttonBitmapVisible,
  IC_IMPORTU buttonTextVisible,
  IC_IMPORTU buttonBitmapAndTextVisible,
  IC_IMPORTU filterMisfits,
  IC_IMPORTU dragDrop,
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  IC_IMPORTU noDragDrop,
#endif // IC_OBSOLETE
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*---------------------------- Tool Bar Contents -----------------------------*/
virtual IToolBar
 &addAsFirst    ( IWindow*      window,
                  bool          startNewGroup = false ),
 &addAsNext     ( IWindow*      window,
                  IWindow*      referenceWindow,
                  bool          startNewGroup = false ),
 &addAsPrevious ( IWindow*      window,
                  IWindow*      referenceWindow,
                  bool          startNewGroup = false ),
 &addAsLast     ( IWindow*      window,
                  bool          startNewGroup = false ),
 &moveToFirst   ( IWindow*      window,
                  bool          startNewGroup = false ),
 &moveAfter     ( IWindow*      window,
                  IWindow*      referenceWindow,
                  bool          startNewGroup = false ),
 &moveBefore    ( IWindow*      window,
                  IWindow*      referenceWindow,
                  bool          startNewGroup = false ),
 &moveToLast    ( IWindow*      window,
                  bool          startNewGroup = false ),
 &remove        ( IWindow*      window );

/*------------------------- Tool Bar Button Behavior -------------------------*/
virtual IToolBar
 &setButtonView ( IToolBarButton::View buttonView );

IToolBarButton::View
  buttonView    ( ) const;

/*---------------------------- Filtering Misfits -----------------------------*/
IToolBar
 &enableMisfitFiltering    ( bool enable = true ),
 &disableMisfitFiltering   ( );

bool
  isMisfitFilteringEnabled ( ) const;

/*---------------------------- Floating Tool Bar -----------------------------*/
virtual IToolBar
 &setFloatingPosition ( const IPoint& frameRelativePosition );

IPoint
  floatingPosition    ( ) const;

virtual IToolBar
 &setFloatingTitle    ( const char* text ),
 &setFloatingTitle    ( const IResourceId& text );

IString
  floatingTitle       ( ) const;

virtual IToolBarFrameWindow
 *floatingFrame       ( );

/*---------------------------- Tool Bar Container ----------------------------*/
virtual IToolBarContainer
 *toolBarContainer ( ) const;

/*---------------------------- Tool Bar Defaults -----------------------------*/
static void
  setDefaultPad         ( long           pixelsOfPad      = -1 ),
  setDefaultMargin      ( const ISize&   sizeOfMargin     = ISize( 7, 4 ) ),
  setDefaultGroupPad    ( unsigned long  pixelsOfGroupPad = 8 ),
  setDefaultMisfitWidth ( unsigned long  maximumWidth     = 65 );

static long
  defaultPad            ( );

static ISize
  defaultMargin         ( );

static unsigned long
  defaultGroupPad       ( ),
  defaultMisfitWidth    ( );

/*--------------------------- Window Painting --------------------------------*/
virtual IToolBar& show  ( bool showWindow = true );
virtual IToolBar& hide  ( );


/*------------------------------ Canvas Layout -------------------------------*/
virtual IToolBar
 &setLayoutDistorted ( unsigned long layoutAttributeOn,
                       unsigned long layoutAttributeOff );

/*--------------------- Expanding/Collapsing the ToolBar ---------------------*/
virtual IToolBar
 &expand     ( bool expand = true ),
 &collapse   ( );

bool
  isExpanded ( ) const;

/*---------------------------- Drag Drop Support -----------------------------*/
virtual IToolBar
 &enableDragDrop  ( bool enable = true ),
 &disableDragDrop ( );

bool
  allowsDragDrop  ( ) const;


class FrameCursor {
public:
/*------------------------------- Constructors -------------------------------*/
  FrameCursor ( const IFrameWindow* frame );
virtual
 ~FrameCursor ( );

/*----------------------------- Cursor Functions -----------------------------*/
virtual bool
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  FrameCursor ( const FrameCursor& );
FrameCursor
 &operator= ( const FrameCursor& );

friend class IToolBar;
IToolBarFrameCursorData
  *fToolBarFrameCursorData;
}; // IToolBar::FrameCursor

class WindowCursor {
public:
/*------------------------------- Constructors -------------------------------*/
  WindowCursor ( const IToolBar* toolbar );
virtual
 ~WindowCursor ( );

/*----------------------------- Cursor Functions -----------------------------*/
virtual bool
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  WindowCursor ( const WindowCursor& );
WindowCursor
 &operator= ( const WindowCursor& );

friend class IToolBar;
IToolBarWindowCursorData
 *fToolBarWindowCursorData;
}; // IToolBar::WindowCursor

/*----------------------------- Cursor Functions -----------------------------*/
static IToolBar
 *toolBarAt ( const FrameCursor& cursor );

IWindow
 *windowAt  ( const WindowCursor& cursor ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  IToolBar ( );

/*------------------------------ Initialization ------------------------------*/
IToolBar
 &initialize ( unsigned long     windowIdentifier,
               IFrameWindow*     ownerFrame,
               Location          frameLocation,
               bool              groupWithPreceding,
               unsigned long     style,
               unsigned long     extendedStyle );

virtual IToolBarContainer
 *createToolBarContainer ( IFrameWindow* frame );

virtual IToolBarFrameWindow
 *createFloatingFrame    ( IFrameWindow* owner );

virtual IToolBar
 &filter ( );

/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

virtual IToolBar
  &layout ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IToolBar  ( const IToolBar& );
IToolBar
 &operator= ( const IToolBar& );

/*--------------------------------- Private ----------------------------------*/
void addControl ( IWindow*  control );

IToolBarContainer
 *createAndVerifyToolBarContainer ( IFrameWindow* frame );

friend class IToolBarContainer;
friend class IToolBarPaintHandler;
friend class IToolBar::WindowCursor;

static Style
  fgCurrentDefaultStyle;

IToolBarData
 *fToolBarData;
}; // IToolBar

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
INESTEDBITFLAGCLASSFUNCS(Style, IToolBar);
#endif

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITBAR_ */
