// ----------------------------------------------------------------------------
// FILE NAME: itime.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     ITime
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 00  1.6.1.6  source/core/base/itime.hpp, appsupport, ioc.v400, 001006  
// ----------------------------------------------------------------------------

#ifndef _ITIME_
#define _ITIME_

#include <istream.hpp>
#include <ibase.hpp>
#include <istring.hpp>

#include <idatstrm.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif


    struct _CTIME;


#endif

#ifndef IC_BUILD
class ITime;
inline ostream& IC_EXPORTB operator<<(ostream& aStream, const ITime& aTime);
#endif

#pragma pack(push,4)
#pragma enum(4)

struct ICnrTime
{
    unsigned char hours;
    unsigned char minutes;
    unsigned char seconds;
    unsigned char ucReserved;
};

class IC_EXPORTB ITime
{
public:
    // ------------------------ Constructors ----------------------------------
    ITime();
    ITime(long seconds);
    ITime(  unsigned hours,
            unsigned minutes,
            unsigned seconds = 0);
    ITime(const ITime &aTime);
    ITime(const ICnrTime &cnrTime);

    // -------------------------- Current Time --------------------------------
    static ITime now();

    // -------------------------- Diagnostics ---------------------------------
    IString asString(const char* fmt = "%X") const;

    friend ostream& IC_EXPORTB
        operator << (ostream& aStream, const ITime& aTime);


    // -------------------------- Time Queries --------------------------------
    long asSeconds() const;

    ICnrTime asICnrTime() const;

    unsigned hours() const;
    unsigned minutes() const;
    unsigned seconds() const;

    // -------------------------- Comparisons ---------------------------------
    bool operator==(const ITime& aTime ) const;
    bool operator!=(const ITime& aTime ) const;
    bool operator< (const ITime& aTime ) const;
    bool operator<=(const ITime& aTime ) const;
    bool operator> (const ITime& aTime ) const;
    bool operator>=(const ITime& aTime ) const;

    // ------------------------- Manipulations --------------------------------
    ITime operator+(const ITime& aTime) const;
    ITime operator-(const ITime& aTime) const;

    ITime& operator+=(const ITime& aTime );
    ITime& operator-=(const ITime& aTime );

    // ------------------------ Streaming -------------------------------------
    void operator>>=(IDataStream& toWhere);
    void operator<<=(IDataStream& fromWhere);

protected:
    // ------------------------ Initialize ------------------------------------
    ITime& initialize(long seconds);

    // ------------------------- Streaming ------------------------------------
    void writeToStream(IDataStream& toWhere) const;
    void readFromStream(IDataStream& fromWhere);


    // ------------------------ Obsolete --------------------------------------
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )

public:
    ITime(const _CTIME& cDate );
    _CTIME asCTIME() const;

#endif

private:
    // ------------------------ Data ------------------------------------------
    long ticks;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <itime.inl>

#endif // _ITIME_





