#ifndef __lc_core_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __lc_core_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   /********************************************************************/
   /*  <lc_core.h> Header File                                         */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

#include <stddef.h>
#include <wctype.h>
#include <wchar.h>
#include <regex.h>
#include <time.h>
#include <stdarg.h>
#include <nl_types.h>

 /*
 ** Valid type ids for type_id above.
 */
#define _LC_CAR       1
#define _LC_LOCALE    2
#define _LC_CHARMAP   3
#define _LC_CTYPE     4
#define _LC_COLLATE   5
#define _LC_NUMERIC   6
#define _LC_MONETARY  7
#define _LC_TIME      8
#define _LC_RESP      9
#define _LC_SYNTAX   10
#define _LC_TOD      11

 /*
 ** Object magic for C/C++
 */
#define _LC_MAGIC     0x4C43

 /*
 ** Version C/C++
 */
#define _LC_VERSION   0x00040000
struct _LC_locale;

#ifndef __lc_object
   #define __lc_object 1
   typedef struct {
      unsigned short
         type_id,
         magic;
      unsigned long
         version;
      size_t  size;
      } _LC_object_t;
#endif

typedef struct {

    _LC_object_t  hdr;

    /* Message Services API Methods */
    unsigned char
            * (*catgets)();
    void    (*catclose)();

    /* Message compression methods */
    char    *(*compress)();
    char    *(*decompress)();
    int     (*start_compress)();
    int     (*end_compress)();

    /* Initialization method */
    int     (*init)();
    void    *data;
} _LC_core_car_t;

struct _LC_charmap;
typedef struct {

    _LC_object_t  hdr;

    /* Process code conversion methods */
    int      (*mbtowc)(struct _LC_charmap*, wchar_t*, const char*, size_t);
    size_t   (*mbstowcs)(struct _LC_charmap*, wchar_t*, const char*, size_t);
    int      (*wctomb)(struct _LC_charmap*, char*, wchar_t);
    size_t   (*wcstombs)(struct _LC_charmap*, char*, const wchar_t*, size_t);

    /* Character encoding length method */
    int      (*mblen)(struct _LC_charmap*, const char*, size_t);

    /* Character display width methods */
    int      (*wcswidth)(struct _LC_charmap*, const wchar_t*, size_t, int*);
    int      (*wcwidth)(struct _LC_charmap*, wint_t);

    /* Character set id methods */
    int      (*csid)(struct _LC_charmap*, const wchar_t*);
    int      (*wcsid)(struct _LC_charmap*, const wchar_t);

    /* character state-dependent encoding methods */
    int      (*mbsinit)(struct _LC_charmap*, const mbstate_t*);
    size_t   (*mbrlen)(struct _LC_charmap*, int*, const char*, size_t, mbstate_t*);
    size_t   (*mbrtowc)(struct _LC_charmap*, int*, wchar_t*, const char*, size_t, mbstate_t*);
    size_t   (*wcrtomb)(struct _LC_charmap*, int*, char*, wchar_t, mbstate_t*);
    size_t   (*mbsrtowcs)(struct _LC_charmap*, int*, wchar_t*, const char**, size_t, mbstate_t*);
    size_t   (*wcsrtombs)(struct _LC_charmap*, int*, char*, const wchar_t*, size_t, mbstate_t*);

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_charmap_t;


struct _LC_ctype;
typedef struct {

    _LC_object_t  hdr;

    /* case convertersion methods */
    wint_t  (*towupper)(struct _LC_ctype*, wint_t);
    wint_t  (*towlower)(struct _LC_ctype*, wint_t);

    /* classification methods */
    wctype_t (*wctype)(struct _LC_ctype*, const char*);
    int      (*iswctype)(struct _LC_ctype*, wint_t, wctype_t);

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_ctype_t;

struct _LC_collate;
typedef struct {

    _LC_object_t  hdr;

    /* character collation methods */
    int      (*strcoll)(struct _LC_collate*, const char*, const char*, int*);
    size_t   (*strxfrm)(struct _LC_collate*, char*, const char*, size_t, int*);

    /* process code collation methods */
    int      (*wcscoll)(struct _LC_collate*, const wchar_t*, const wchar_t*, int*);
    size_t   (*wcsxfrm)(struct _LC_collate*, wchar_t*, const wchar_t*, size_t, int*);

    /* filename matching methods */
    int      (*fnmatch)(void);

    /* regular expression methods */
    int      (*regcomp)(struct _LC_collate*, regex_t*, const char*, int);
    size_t   (*regerror)(struct _LC_collate*, int, const regex_t*, char*, size_t);
    int      (*regexec)(struct _LC_collate*, const regex_t*, const char*, size_t, regmatch_t*, int);
    void     (*regfree)(struct _LC_collate*, regex_t*);

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_collate_t;


struct _LC_time;
struct _LC_tod;
typedef struct {

    _LC_object_t  hdr;

    /* time character string formatting methods */
    size_t   (*strftime)(struct _LC_time*, struct _LC_tod*, char*, size_t, const char*, const struct tm*);
    char     *(*strptime)(struct _LC_time*, const char*, const char*, struct tm*);

    /* time process code string formatting methods */
    size_t   (*wcsftime)(struct _LC_time*, struct _LC_tod*, wchar_t*, size_t, const wchar_t*, const struct tm*);

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;

    /* date/time formatting convention method */
    struct dtconv  *(*localdtconv)(struct _LC_time*);
} _LC_core_time_t;


struct _LC_monetary;
typedef struct {

    _LC_object_t  hdr;

    /* character string monetary formatting method */
    int      (*strfmon)(struct _LC_monetary*, char*, size_t, const char*, va_list);

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_monetary_t;


typedef struct {

    _LC_object_t  hdr;

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_numeric_t;


struct _LC_resp;
typedef struct {

    _LC_object_t  hdr;

    /* response matching method */
    int         (*rpmatch)(struct _LC_resp*, const char*);

    /* implementation initialization */
    int         (*init)(struct _LC_locale*);
    void        *data;
} _LC_core_resp_t;


typedef struct {

    _LC_object_t  hdr;

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_syntax_t;


typedef struct {

    _LC_object_t  hdr;

    /* implementation initialization */
    int      (*init)(struct _LC_locale*);
    void     *data;
} _LC_core_tod_t;


struct _LC_locale;
typedef struct {

    _LC_object_t hdr;

    /* langinfo method */
    char         *(*nl_langinfo)(struct _LC_locale*, nl_item);
    struct lconv * (*localeconv)(struct _LC_locale*);

    /* Initialization */
    int          (*init)(struct _LC_locale*);
    void         *data;
} _LC_core_locale_t;

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

