#ifndef __new_h
   #define __new_h

   /********************************************************************/
   /*  <new.h> header file                                             */
   /*                                                                  */
   /*  Licensed Materials - Property of IBM                            */
   /*                                                                  */
   /*  IBM C and C++ Compilers, Version 3.6                            */
   /*  Copyright (C) International Business Machines Corp., 1991, 1997 */
   /*  All rights reserved                                             */
   /*                                                                  */
   /*  US Government Users Restricted Rights -                         */
   /*  Use, duplication, or disclosure restricted                      */
   /*  by GSA ADP Schedule Contract with IBM Corp.                     */
   /*                                                                  */
   /********************************************************************/
   #include <stddef.h>

   // Definition of C++ storage management -- new & delete

   void (*set_new_handler (void(*)()))();
   #ifdef __MULTI__
      void (*_set_mt_new_handler (void(*)()))();
   #endif

   // The standard favourites

   #ifndef __DEBUG_ALLOC__
      void *operator new(size_t size);
      void *operator new(size_t size, void *location);

      void *operator new[](size_t size);
      void *operator new[](size_t size, void *location);

      void operator delete(void *location);

      void operator delete[](void *location);
   #else
      #include <stdlib.h>

      void *operator new(size_t size, const char *filename, size_t lineno);
      void *operator new(size_t size, const char *filename, size_t lineno, void *location);

      void *operator new[](size_t size, const char *filename, size_t lineno);
      void *operator new[](size_t size, const char *filename, size_t lineno, void *location);

      void operator delete(void *location, const char *filename, size_t lineno);

      void operator delete[](void *location, const char *filename, size_t lineno);
   #endif
#endif
