#ifndef __stdarg_h

   #if __IBMC__ || __IBMCPP__
      #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
      #pragma info( restore )
   #endif

   #define __stdarg_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   /********************************************************************/
   /*  <stdarg.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #ifdef _M_I386
      typedef char *va_list;

      #define __nextword(base)   (((unsigned)(sizeof(base))+3U)&~(3U))

      #ifdef __cplusplus
         #define va_start(ap, last) (void)(ap = __vastart(last))
      #else
         #define va_start(ap, last) (void)(ap = ((va_list)&last) + __nextword(last))
      #endif
      #define va_arg(ap, type) ((type *) ((ap += (int) __nextword(type)) - __nextword(type)))[0]
      #define va_end(ap)       (void)(ap = 0)
   #elif __THW_PPC__ && __WINDOWS__
      typedef char *va_list;

      #define __nextword(base)   (((unsigned)(sizeof(base))+3U)&~(3U))
      #define __allign(ap, type) ((va_list)(((int)(ap)+(3+(sizeof(type)>4)*4))&(~3-(sizeof(type)>4)*4)))

      #ifdef __cplusplus
         #define va_start(ap, last) (void)(ap = __vastart(last))
      #else
         #define va_start(ap, last) (void)(ap = ((va_list)&last) + __nextword(last))
      #endif
      #define va_arg(ap, type) ((type *) ((ap =  __allign(ap, type)+(int)__nextword(type)) - __nextword(type)))[0]
      #define va_end(ap)       (void)(ap = 0)
   #else
      /* WPOS ABI compliant definition */
      #if __IBMC__ || __IBMCPP__

         #ifndef __def_va_list
         #define __def_va_list
         typedef struct __va_list_struct {
            char gpr;
            char fpr;
            char reserved[2];
            char *input_arg_area;
            char *reg_save_area;
         } __va_list[1];
         #endif

         extern void _Builtin __vastart(void *);
         extern void* __va_arg(void*, int);

         #define __va_start(ap,fmt) __vastart(&ap)
         #define __va_arg(ap,t)  (*((t*)__va_arg(ap,__builtin_va_arg_incr((t *)0))))
         #define __va_end(ap)

         #define va_start __va_start
         #define va_arg   __va_arg
         #define va_end   __va_end

         typedef __va_list va_list;
      #else

         #ifndef __def_va_list
            #define __def_va_list
            /* The definitions for vararg processing are copied from  */
            /* Metaware header file.                                  */
            typedef struct {
            #ifdef _NEW_ABI
               /* The one that is going to be documented in the ABI:
               * gpr -- index into the array of 8 GPRs stored in the register
               *        save area; gpr=0 corresponds to r3, gpr=1 to r4, etc.
               * fpr -- index into the array of 8 FPRs stored in the
               *        register save area; fpr=0 corresponds to f1, fpr=1
               *        to f2, etc.
               * input_arg_area -- location in input argument area which
               *        may have the next var arg that was passed in memory.
               * reg_save_area -- where r3:r10 and f1:f8 (if saved) are stored.
               */
               char gpr;
               char fpr;
               char reserved[2];
               char *input_arg_area;
               char *reg_save_area;
            #else
               /* vararg_usage_info -- is break down to as follow. Each
               * field initially record the number of "known" register
               * and "memory" argument (before the "...").
               * 4 -- number of word used in General Argument Registers.
               * 4 -- number of double used in Floating Point Argument Registers.
               * 24 --  number of bytes passed in overflow area.
               */
               unsigned long vararg_usage_info;
               unsigned long *overflow_area;
               unsigned long *arg_save_area;
            #endif
               } __va_list[1];
         #endif

         #ifdef _NEW_ABI
         #   ifdef __FSOFT
         #       define __VA_INFO_CLASS  4
         #   else
         #       define __VA_INFO_CLASS  3
         #   endif
         #else
         #   define __VA_INFO_CLASS      2
         #endif

         extern void __builtin_va_info(void*);
         extern void* __va_arg(void*, int);

         #define __va_start(ap,fmt) __builtin_va_info(&ap)
         #define __va_arg(ap,t)      (*((t*)__va_arg(ap,_INFO(t,__VA_INFO_CLASS))))
         #define __va_end(ap)


         #define va_start __va_start
         #define va_arg   __va_arg
         #define va_end   __va_end

         typedef __va_list va_list;

      #endif

   #endif

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
      #pragma info( restore )
   #endif

#endif

