#ifndef __STDEXCEPT_H
#define __STDEXCEPT_H
/*
 *   COMPONENT_NAME: STDEXCEPT
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1995, 1997
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

class exception {
public:
  exception(const char* exceptionName) : desc(exceptionName), alloced(0) { } 
  virtual ~exception();
  virtual const char* what() const { return desc; }
protected: 
  exception() : desc(0), alloced(0) { }
private:
  const char* desc;
  unsigned int alloced;
};

class logic_error : public exception {
public:
  logic_error(const char* exceptionName) : exception(exceptionName) { }
  virtual ~logic_error();
};

class bad_cast : public logic_error {
public:
  bad_cast(const char* = 0) : logic_error ("bad_cast") { }
  virtual ~bad_cast();
};  

class bad_typeid: public logic_error {
public:
  bad_typeid(const char* = 0) : logic_error ("bad_typeid") { }
  virtual ~bad_typeid();
};  

#endif /* __STDEXCEPT_H */
