#ifndef __string_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __string_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined _OPTLINK_SUPPORTED
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <string.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/


   #if !defined __COMPATSTR__ || (__IBMCPP__ < 400)
      #undef __COMPATSTR__
      #define __COMPATSTR__ 1
   #endif

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   #ifndef NULL
      #if __EXTENDED__ || __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   #if (__THW_INTEL__ || __THW_PPC__ && __STR__) && (__IBMC__ || __IBMCPP__)
      #ifdef __cplusplus
         extern "builtin" char  *__strcpy(char*, const char*);
         extern "builtin" int    __strcmp(const char *, const char*);
         extern "builtin" size_t __strlen(const char*);
         extern "builtin" char  *__strchr(const char*, int);
         extern "builtin" char  *__strrchr(const char *, int);
         extern "builtin" char  *__strcat(char*, const char*);
         inline char *_LNK_CONV strcpy(char *__s1, const char *__s2)
                                 { return __strcpy(__s1, __s2); }
         inline int _LNK_CONV strcmp(const char *__s1, const char *__s2)
                                 { return __strcmp(__s1, __s2); }
         inline size_t _LNK_CONV strlen(const char *__s)
                                 { return __strlen(__s); }
         #if __COMPATSTR__
            inline char *_LNK_CONV strchr(const char *__s, int __ch)
                                    { return __strchr(__s, __ch); }
            inline char *_LNK_CONV strrchr(const char *__s1, int __ch)
                                    { return __strrchr(__s1, __ch); }
         #else
            inline const char *_LNK_CONV strchr(const char *__s, int __ch)
                                    { return __strchr(__s, __ch); }
            inline const char *_LNK_CONV strrchr(const char *__s1, int __ch)
                                    { return __strrchr(__s1, __ch); }
         #endif
         inline char *_LNK_CONV strcat(char *__s1, const char *__s2)
                                 { return __strcat(__s1, __s2); }
      #else
         char  *_Builtin __strcpy(char*, const char*);
         int    _Builtin __strcmp(const char*, const char*);
         size_t _Builtin __strlen(const char*);
         char  *_Builtin __strchr(const char*, int);
         char  *_Builtin __strrchr(const char*, int);
         char  *_Builtin __strcat(char*, const char*);
         extern char * _IMPORT _LNK_CONV strcat(char *, const char *);
         extern char * _IMPORT _LNK_CONV strchr(const char *, int);
         extern int    _IMPORT _LNK_CONV strcmp(const char *, const char *);
         extern char * _IMPORT _LNK_CONV strcpy(char *, const char *);
         extern size_t _IMPORT _LNK_CONV strlen(const char *);
         extern char * _IMPORT _LNK_CONV strrchr(const char *, int);
         #define strcat(x, y)    __strcat(x, y)
         #define strcpy(x, y)    __strcpy(x, y)
         #define strchr(x, y)    __strchr(x, y)
         #define strcmp(x, y)    __strcmp(x, y)
         #define strlen(x)       __strlen(x)
         #define strrchr(x, y)   __strrchr(x, y)
      #endif

      #pragma isolated_call(__strcpy)
      #pragma isolated_call(__strcmp)
      #pragma isolated_call(__strlen)
      #pragma isolated_call(__strchr)
      #pragma isolated_call(__strrchr)
      #pragma isolated_call(__strcat)

      #if __THW_INTEL__
         #if __cplusplus
            extern "builtin" char *__strncat(char *, const char *, size_t);
            extern "builtin" int   __strncmp(const char *, const char *, size_t);
            extern "builtin" char *__strncpy(char *, const char *, size_t);
            inline char *_LNK_CONV strncat(char *__s1, const char *__s2, size_t __len)
                                 { return __strncat(__s1, __s2, __len); }
            inline int _LNK_CONV strncmp(const char *__s1, const char *__s2, size_t __len)
                                 { return __strncmp(__s1, __s2, __len); }
            inline char *_LNK_CONV strncpy(char *__s1, const char *__s2, size_t __len)
                                 { return __strncpy(__s1, __s2, __len); }
         #else
            char *_Builtin __strncat(char *, const char *, size_t);
            int   _Builtin __strncmp(const char *, const char *, size_t);
            char *_Builtin __strncpy(char *, const char *, size_t);
            extern char *_IMPORT _LNK_CONV strncat(char *, const char *, size_t);
            extern int   _IMPORT _LNK_CONV strncmp(const char *, const char *, size_t);
            extern char *_IMPORT _LNK_CONV strncpy(char *, const char *, size_t);
            #define strncat(x, y, z) __strncat(x, y, z)
            #define strncmp(x, y, z) __strncmp(x, y, z)
            #define strncpy(x, y, z) __strncpy(x, y, z)
         #endif
         #pragma isolated_call(__strncat)
         #pragma isolated_call(__strncmp)
         #pragma isolated_call(__strncpy)
      #endif
   #else
      char  *_IMPORT _LNK_CONV strcat(char *, const char *);
      #if __cplusplus && !__COMPATSTR__
         const char *_IMPORT _LNK_CONV strchr(const char *, int);
         const char *_IMPORT _LNK_CONV strrchr(const char *, int);
      #else
         char *_IMPORT _LNK_CONV strchr(const char *, int);
         char  *_IMPORT _LNK_CONV strrchr(const char *, int);
      #endif
      int    _IMPORT _LNK_CONV strcmp(const char *, const char *);
      char  *_IMPORT _LNK_CONV strcpy(char *, const char *);
      size_t _IMPORT _LNK_CONV strlen(const char *);
      char  *_IMPORT _LNK_CONV strncat(char *, const char *, size_t);
      int    _IMPORT _LNK_CONV strncmp(const char *, const char *, size_t);
      char  *_IMPORT _LNK_CONV strncpy(char *, const char *, size_t);
   #endif

   #ifdef __DEBUG_ALLOC__
      /* BEGIN CHANGES - Defect 88346 */
      /* Replace double underscore to single underscore */
      char *_IMPORT _LNK_CONV _debug_strcat(char *, const char *, const char *, size_t);
      char *_IMPORT _LNK_CONV _debug_strcpy(char *, const char *, const char *, size_t);
      char *_IMPORT _LNK_CONV _debug_strncat(char *, const char *, size_t, const char *, size_t);
      char *_IMPORT _LNK_CONV _debug_strncpy(char *, const char *, size_t, const char *, size_t);
      #undef strcat
      #undef strcpy
      #undef strncat
      #undef strncpy
      #define strcat(x, y) _debug_strcat(x, y, __FILE__, __LINE__)
      #define strcpy(x, y) _debug_strcpy(x, y, __FILE__, __LINE__)
      #define strncat(x, y, z) _debug_strncat(x, y, z, __FILE__, __LINE__)
      #define strncpy(x, y, z) _debug_strncpy(x, y, z, __FILE__, __LINE__)
      /* END CHANGES - Defect 88346 */
   #endif

   extern int    _IMPORT _LNK_CONV strcoll(const char *, const char *);
   extern size_t _IMPORT _LNK_CONV strcspn(const char *, const char *);
   extern char * _IMPORT _LNK_CONV strerror(int);
   extern size_t _IMPORT _LNK_CONV strspn(const char *, const char *);
   extern char  *_IMPORT _LNK_CONV strtok(char*, const char *);
   extern size_t _IMPORT _LNK_CONV strxfrm(char *, const char *, size_t);
   #if __cplusplus && !__COMPATSTR__
      extern const char *_IMPORT _LNK_CONV strpbrk(const char *, const char *);
      extern const char *_IMPORT _LNK_CONV strstr(const char *, const char *);
   #else
      extern char  *_IMPORT _LNK_CONV strpbrk(const char *, const char *);
      extern char  *_IMPORT _LNK_CONV strstr(const char *, const char *);
   #endif

   #ifndef __memory_h
      #if (__THW_INTEL__ || __THW_PPC__ && __STR__) && (__IBMC__ || __IBMCPP__)
         #if __cplusplus
            extern "builtin" void  *__memchr(const void *, int, size_t);
            extern "builtin" void  *__memcpy(void *, const void *, size_t);
            extern "builtin" int __memcmp(const void *, const void *, size_t);
            extern "builtin" void  *__memmove(void *, const void *, size_t);
            extern "builtin" void  *__memset(void *, int, size_t);
            #if __COMPATSTR__
               inline void *_LNK_CONV memchr(const void *__m, int __ch, size_t __len)
                                    { return __memchr(__m, __ch, __len); }
            #else
               inline const void *_LNK_CONV memchr(const void *__m, int __ch, size_t __len)
                                    { return __memchr(__m, __ch, __len); }
            #endif
            inline int   _LNK_CONV memcmp(const void *__m1, const void *__m2, size_t __len)
                                   { return __memcmp(__m1, __m2, __len); }
            inline void *_LNK_CONV memcpy(void *__m1, const void *__m2, size_t __len)
                                   { return __memcpy(__m1, __m2, __len); }
            inline void *_LNK_CONV memmove(void *__m1, const void *__m2, size_t __len)
                                   { return __memmove(__m1, __m2, __len); }
            inline void *_LNK_CONV memset(void *__m, int __ch, size_t __len)
                                   { return __memset(__m, __ch, __len); }
         #else
            void *_Builtin __memchr(const void *, int, size_t);
            void *_Builtin __memcpy(void *, const void *, size_t);
            int   _Builtin __memcmp(const void *, const void *, size_t);
            void *_Builtin __memmove(void *, const void *, size_t);
            void *_Builtin __memset(void *, int, size_t);
            extern void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
            extern int   _IMPORT _LNK_CONV memcmp(const void *, const void *, size_t);
            extern void *_IMPORT _LNK_CONV memcpy(void *, const void *, size_t);
            extern void *_IMPORT _LNK_CONV memmove(void *, const void *, size_t);
            extern void *_IMPORT _LNK_CONV memset(void *, int, size_t);

            #define memchr(x, y, z)  __memchr(x, y, z)
            #define memcmp(x, y, z)  __memcmp(x, y, z)
            #define memcpy(x, y, z)  __memcpy(x, y, z)
            #define memmove(x, y, z)  __memmove(x, y, z)
            #define memset(x, y, z)  __memset(x, y, z)
         #endif
         #pragma isolated_call(__memchr)
         #pragma isolated_call(__memcpy)
         #pragma isolated_call(__memcmp)
         #pragma isolated_call(__memmove)
         #pragma isolated_call(__memset)
      #else
         extern void *_IMPORT _LNK_CONV memcpy(void *, const void *, size_t);
         #if __cplusplus && !__COMPATSTR__
            extern const void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
         #else
            extern void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
         #endif
         extern int   _IMPORT _LNK_CONV memcmp(const void *, const void *, size_t);
         extern void *_IMPORT _LNK_CONV memset(void *, int, size_t);
      #endif

      extern void *_IMPORT _LNK_CONV memccpy(void *, const void *, int, unsigned int);
      extern int   _IMPORT _LNK_CONV memicmp(const void *, const void *, unsigned int);

      extern void *_IMPORT _LNK_CONV _fmemcpy(void *, const void *, size_t);
      extern void *_IMPORT _LNK_CONV _fmemchr(const void *, int, size_t);
      extern int   _IMPORT _LNK_CONV _fmemcmp(const void *, const void *, size_t);
      extern void *_IMPORT _LNK_CONV _fmemset(void *, int, size_t);
      extern void *_IMPORT _LNK_CONV _fmemccpy(void *, const void *, int, unsigned int);
      extern int   _IMPORT _LNK_CONV _fmemicmp(const void *, const void *, unsigned int);

      #ifdef __DEBUG_ALLOC__
         /* BEGIN CHANGES - Defect 88346 */
         /* Replace double underscore to single underscore */
         extern void *_IMPORT _LNK_CONV _debug_memcpy(void *, const void *, size_t, const char *, size_t);
         extern void *_IMPORT _LNK_CONV _debug_memset(void *, int, size_t, const char *, size_t);
         extern void *_IMPORT _LNK_CONV _debug_memmove(void *, const void *, size_t, const char *, size_t);
         #undef memcpy
         #undef memset
         #undef memmove
         #define memcpy(x, y, z) _debug_memcpy(x, y, z, __FILE__, __LINE__)
         #define memset(x, y, z) _debug_memset(x, y, z, __FILE__, __LINE__)
         #define memmove(x, y, z) _debug_memmove(x, y, z, __FILE__, __LINE__)
         /* END CHANGES - Defect 88346 */
      #endif

      #if __IBMC__ || __IBMCPP__
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(_fmemcpy, "?memcpy")
            #pragma map(_fmemchr, "?memchr")
            #pragma map(_fmemcmp, "?memcmp")
            #pragma map(_fmemset, "?memset")
            #pragma map(_fmemccpy, "?memccpy")
            #pragma map(_fmemicmp, "?memicmp")
         #else
            #pragma map(_fmemcpy, "memcpy")
            #pragma map(_fmemchr, "memchr")
            #pragma map(_fmemcmp, "memcmp")
            #pragma map(_fmemset, "memset")
            #pragma map(_fmemccpy, "memccpy")
            #pragma map(_fmemicmp, "memicmp")
         #endif
      #else
         #define _fmemcpy memcpy
         #define _fmemchr memchr
         #define _fmemcmp memcmp
         #define _fmemset memset
         #define _fmemccpy memccpy
         #define _fmemicmp memicmp
      #endif
   #endif

   #if __EXTENDED__
      char *_IMPORT _LNK_CONV strdup(const char *);
      int   _IMPORT _LNK_CONV stricmp(const char *, const char *);
      char *_IMPORT _LNK_CONV strlwr(char *);
      int   _IMPORT _LNK_CONV strnicmp(const char *, const char *, size_t);
      char *_IMPORT _LNK_CONV strupr(char *);
      int   _IMPORT _LNK_CONV strcmpi(const char *, const char *);
      char *_IMPORT _LNK_CONV strrev(char *);
      char *_IMPORT _LNK_CONV strset(char *, int);
      char *_IMPORT _LNK_CONV strnset(char *, int, size_t);
      char *_IMPORT _LNK_CONV _strerror(const char *);

      #if (__IBMC__ || IBMCPP__) && __LIBANSI__
         #pragma isolated_call(stricmp)
         #pragma isolated_call(strlwr)
         #pragma isolated_call(strnicmp)
         #pragma isolated_call(strupr)
         #pragma isolated_call(strcmpi)
         #pragma isolated_call(strrev)
         #pragma isolated_call(strset)
         #pragma isolated_call(strnset)
         #if __IGNERRNO__
            #pragma isolated_call(strdup)
            #pragma isolated_call(_strerror)
         #endif
      #endif

      #ifdef __DEBUG_ALLOC__
         /* BEGIN CHANGES - Defect 88346 */
         /* Replace double underscore to single underscore */
         char * _IMPORT _LNK_CONV _debug_strset(char *, int, const char *, size_t);
         char * _IMPORT _LNK_CONV _debug_strnset(char *, int, size_t, const char *, size_t);
         char * _IMPORT _LNK_CONV _debug_strdup(const char * , const char *, size_t);
         #undef strset
         #undef strnset
         #undef strdup
         #define strset(x, y) _debug_strset(x, y, __FILE__, __LINE__)
         #define strnset(x, y, z) _debug_strnset(x, y, z, __FILE__, __LINE__)
         #define strdup(x) _debug_strdup(x, __FILE__, __LINE__)
         /* END CHANGES - Defect 88346 */
      #endif

      size_t _IMPORT _LNK_CONV _fstrcspn(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrdup(const char *);
      char  *_IMPORT _LNK_CONV _nstrdup(const char *);
      int    _IMPORT _LNK_CONV _fstricmp(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrlwr(char *);
      int    _IMPORT _LNK_CONV _fstrnicmp(const char *, const char *, size_t);
      char  *_IMPORT _LNK_CONV _fstrnset(char *, int, size_t);
      char  *_IMPORT _LNK_CONV _fstrpbrk(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrrev(char *);
      char  *_IMPORT _LNK_CONV _fstrset(char *, int);
      size_t _IMPORT _LNK_CONV _fstrspn(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrstr(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrtok(char*, const char *);
      char  *_IMPORT _LNK_CONV _fstrupr(char *);
      void  *_IMPORT _LNK_CONV _fmemmove(void *, const void *, size_t);
      char  *_IMPORT _LNK_CONV _fstrcat(char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrchr(const char *, int);
      int    _IMPORT _LNK_CONV _fstrcmp(const char *, const char *);
      char  *_IMPORT _LNK_CONV _fstrcpy(char *, const char *);
      size_t _IMPORT _LNK_CONV _fstrlen(const char *);
      char  *_IMPORT _LNK_CONV _fstrncat(char *, const char *, size_t);
      int    _IMPORT _LNK_CONV _fstrncmp(const char *, const char *, size_t);
      char  *_IMPORT _LNK_CONV _fstrncpy(char *, const char *, size_t);
      char  *_IMPORT _LNK_CONV _fstrrchr(const char *, int);

      #if __IBMC__ || __IBMCPP__
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(_fstrcspn, "?strcspn")
            #pragma map(_fstrdup, "?strdup")
            #pragma map(_nstrdup, "?strdup")
            #pragma map(_fstricmp, "?stricmp")
            #pragma map(_fstrlwr, "?strlwr")
            #pragma map(_fstrnicmp, "?strnicmp")
            #pragma map(_fstrnset, "?strnset")
            #pragma map(_fstrpbrk, "?strpbrk")
            #pragma map(_fstrrev, "?strrev")
            #pragma map(_fstrset, "?strset")
            #pragma map(_fstrspn, "?strspn")
            #pragma map(_fstrstr, "?strstr")
            #pragma map(_fstrtok, "?strtok")
            #pragma map(_fstrupr, "?strupr")
            #pragma map(_fmemmove, "?memmove")
            #pragma map(_fstrcat, "?strcat")
            #pragma map(_fstrchr, "?strchr")
            #pragma map(_fstrcmp, "?strcmp")
            #pragma map(_fstrcpy, "?strcpy")
            #pragma map(_fstrlen, "?strlen")
            #pragma map(_fstrncat, "?strncat")
            #pragma map(_fstrncmp, "?strncmp")
            #pragma map(_fstrncpy, "?strncpy")
            #pragma map(_fstrrchr, "?strrchr")
         #else
            #pragma map(_fstrcspn, "strcspn")
            #pragma map(_fstrdup, "strdup")
            #pragma map(_nstrdup, "strdup")
            #pragma map(_fstricmp, "stricmp")
            #pragma map(_fstrlwr, "strlwr")
            #pragma map(_fstrnicmp, "strnicmp")
            #pragma map(_fstrnset, "strnset")
            #pragma map(_fstrpbrk, "strpbrk")
            #pragma map(_fstrrev, "strrev")
            #pragma map(_fstrset, "strset")
            #pragma map(_fstrspn, "strspn")
            #pragma map(_fstrstr, "strstr")
            #pragma map(_fstrtok, "strtok")
            #pragma map(_fstrupr, "strupr")
            #pragma map(_fmemmove, "memmove")
            #pragma map(_fstrcat, "strcat")
            #pragma map(_fstrchr, "strchr")
            #pragma map(_fstrcmp, "strcmp")
            #pragma map(_fstrcpy, "strcpy")
            #pragma map(_fstrlen, "strlen")
            #pragma map(_fstrncat, "strncat")
            #pragma map(_fstrncmp, "strncmp")
            #pragma map(_fstrncpy, "strncpy")
            #pragma map(_fstrrchr, "strrchr")
         #endif
      #else
         #define _fstrcspn strcspn
         #define _fstrdup strdup
         #define _nstrdup strdup
         #define _fstricmp stricmp
         #define _fstrlwr strlwr
         #define _fstrnicmp strnicmp
         #define _fstrnset strnset
         #define _fstrpbrk strpbrk
         #define _fstrrev strrev
         #define _fstrset strset
         #define _fstrspn strspn
         #define _fstrstr strstr
         #define _fstrtok strtok
         #define _fstrupr strupr
         #define _fmemmove memmove
         #define _fstrcat strcat
         #define _fstrchr strchr
         #define _fstrcmp strcmp
         #define _fstrcpy strcpy
         #define _fstrlen strlen
         #define _fstrncat strncat
         #define _fstrncmp strncmp
         #define _fstrncpy strncpy
         #define _fstrrchr strrchr
      #endif
   #endif

   #if __cplusplus
      }
      #if !__COMPATSTR__
         inline char *strchr(char *__s, int __ch)
                                    { return (char*)strchr((const char *)__s, __ch); }
         inline char *strpbrk(char *__s1, const char *__s2)
                                    { return (char*)strpbrk((const char *)__s1, __s2); }
         inline char *strrchr(char *__s, int __ch)
                                    { return (char*)strrchr((const char *)__s, __ch); }
         inline char *strstr(char *__s1, const char *__s2)
                                    { return (char*)strstr((const char *)__s1, __s2); }
         #ifndef __memory_h
            inline void *memchr(void *__s, int __ch, size_t __n)
                                       { return (void*)memchr((const void *)__s, __ch, __n); }
         #endif
      #endif
   #endif

   #ifndef __memory_h
      #define __memory_h
   #endif

   #if (__IBMC__ || IBMCPP__) && __LIBANSI__
      #pragma isolated_call(strcpy)
      #pragma isolated_call(strncpy)
      #pragma isolated_call(strcat)
      #pragma isolated_call(strncat)
      #pragma isolated_call(strcmp)
      #pragma isolated_call(strncmp)
      #pragma isolated_call(strchr)
      #pragma isolated_call(strcspn)
      #pragma isolated_call(strpbrk)
      #pragma isolated_call(strrchr)
      #pragma isolated_call(strspn)
      #pragma isolated_call(strstr)
      #pragma isolated_call(strlen)

      #pragma isolated_call(memcpy)
      #pragma isolated_call(memmove)
      #pragma isolated_call(memcmp)
      #pragma isolated_call(memchr)
      #pragma isolated_call(memset)
      #pragma isolated_call(memccpy)
      #pragma isolated_call(memicmp)
      #if __IGNERRNO__
         #pragma isolated_call(strerror)
         #pragma isolated_call(strcoll)
         #pragma isolated_call(strxfrm)
      #endif
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

