#ifndef __timeb_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __timeb_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <sys\timeb> Header File                                         */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if __EXTENDED__

      #ifndef  __time_t
         #define __time_t
         typedef double time_t;
      #endif


      struct timeb {
         time_t time;
         unsigned short millitm;
         short timezone;
         short dstflag;
         };

      extern void _IMPORT _LNK_CONV _ftime(struct timeb *);

      #if __IBMC__ || __IBMCPP__
         extern void _IMPORT _LNK_CONV ftime(struct timeb *);
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(ftime, "?__ftime")
         #else
            #pragma map(ftime, "__ftime")
         #endif
      #else 
         #define ftime  __ftime
         #define _ftime __ftime
      #endif
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

