#ifndef __utime_h
   #define __utime_h

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <sys\utime.h> Header File                                       */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if __EXTENDED__

      #ifndef __time_t
         #define __time_t
         typedef double time_t;
      #endif

      /* define struct used by _utime() function */

      struct utimbuf {
         time_t actime;          /* access time */
         time_t modtime;         /* modification time */
         };

      /* function prototypes */

      extern int _IMPORT _LNK_CONV _utime(char *, struct utimbuf*);
      extern int _IMPORT _LNK_CONV utime(char *, struct utimbuf*);

      #if __IBMC__ || __IBMCPP__
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(utime, "?__utime")
         #else
            #pragma map(utime, "__utime")
         #endif
      #else
         #define utime  __utime
         #define _utime __utime
      #endif

   #endif

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif

#endif


