#ifndef _H_TYPEINFO_
#define _H_TYPEINFO_
/*
 *   COMPONENT_NAME: TYPEINFO
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1995, 1997
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#include <string.h>

class type_info {
  public:
    typedef int         Bool;   // typedef to 'bool' when it is supported.

    virtual             ~type_info();
    Bool                operator==(const type_info&) const;
    Bool                operator!=(const type_info&) const;
    Bool                before(const type_info&) const;
    const char*         name() const;

  private:
                        type_info(const type_info&);
    type_info&          operator=(const type_info&);

  protected:
    char *              typeName;
    char *              mangledName;
};

inline const char * type_info::name() const {
  return typeName;
}

inline type_info::Bool type_info::operator==(const type_info&x) const {
  return (&x==this) || (strcmp(x.mangledName,this->mangledName)==0);
}

inline type_info::Bool type_info::operator!=(const type_info&x) const {
  return (&x!=this) && (strcmp(x.mangledName,this->mangledName)!=0);
}

inline type_info::Bool type_info::before(const type_info&x) const {
  return (&x!=this) && (strcmp(x.mangledName,this->mangledName)>=0);
}

#endif /* _H_TYPEINFO_ */
