#ifndef __wchar_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __wchar_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined _OPTLINK_SUPPORTED
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <wchar.h> Header File                                           */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if !defined __COMPATSTR__ || (__IBMCPP__ < 400)
      #undef __COMPATSTR__
      #define __COMPATSTR__ 1
   #endif

   #ifndef NULL
      #ifdef __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   #ifndef __mbstate_t
      #define __mbstate_t
      typedef short mbstate_t;
   #endif

   #ifndef __size_t
      typedef unsigned int size_t;
      #define __size_t
   #endif

   #if !__cplusplus && !defined __wchar_t
      typedef unsigned short wchar_t;
      #define __wchar_t
   #endif

   #ifndef __wint_t
      #define __wint_t
      typedef int  wint_t;
   #endif

   #ifndef WEOF
      #define WEOF ((wint_t)-1)
   #endif

   #ifndef WCHAR_MAX
      #define WCHAR_MAX ((wchar_t)-1)
   #endif

   #ifndef WCHAR_MIN
      #define WCHAR_MIN 0
   #endif

   struct tm;
   struct __file;

   #ifndef __def_va_list
      #define __def_va_list
      #if __THW_PPC__ && __OS2__
         typedef struct {
            char gpr;
            char fpr;
            char reserved[2];
            char *input_arg_area;
            char *reg_save_area;
         } __va_list[1];
      #else
         typedef char *__va_list;
      #endif
   #endif

   /* Wide character I/O functions */

   extern int      _IMPORT _LNK_CONV wprintf(const wchar_t *, ...);
   extern int      _IMPORT _LNK_CONV fwprintf(struct __file *, const wchar_t *, ...);
   extern int      _IMPORT _LNK_CONV swprintf(wchar_t *, size_t, const wchar_t *, ...);
   extern int      _IMPORT _LNK_CONV vwprintf(const wchar_t *, __va_list);
   extern int      _IMPORT _LNK_CONV vfwprintf(struct __file *, const wchar_t *, __va_list);
   extern int      _IMPORT _LNK_CONV vswprintf(wchar_t *, size_t, const wchar_t *, __va_list);
   extern int      _IMPORT _LNK_CONV wscanf(const wchar_t *, ...);
   extern int      _IMPORT _LNK_CONV fwscanf(struct __file *, const wchar_t *, ...);
   extern int      _IMPORT _LNK_CONV swscanf(const wchar_t *, const wchar_t *, ...);
   extern wint_t   _IMPORT _LNK_CONV fgetwc(struct __file *);
   extern wchar_t *_IMPORT _LNK_CONV fgetws(wchar_t *, int, struct __file *);
   extern wint_t   _IMPORT _LNK_CONV fputwc(wchar_t, struct __file *);
   extern int      _IMPORT _LNK_CONV fputws(const wchar_t *, struct __file *);
   extern wint_t   _IMPORT _LNK_CONV getwc(struct __file *);
   extern wint_t   _IMPORT _LNK_CONV getwchar(void);
   extern wint_t   _IMPORT _LNK_CONV putwc(wchar_t, struct __file *);
   extern wint_t   _IMPORT _LNK_CONV putwchar(wchar_t);
   extern wint_t   _IMPORT _LNK_CONV ungetwc(wint_t, struct __file *);
   extern int      _IMPORT _LNK_CONV fwide(struct __file *, int);

   extern double _IMPORT _LNK_CONV wcstod(const wchar_t *, wchar_t **);
   extern long int _IMPORT _LNK_CONV wcstol(const wchar_t *, wchar_t **, int);
   extern long long int _IMPORT _LNK_CONV wcstoll(const wchar_t *, wchar_t **, int);
   extern unsigned long int _IMPORT _LNK_CONV wcstoul(const wchar_t *, wchar_t **, int);
   extern unsigned long long int _IMPORT _LNK_CONV wcstoull(const wchar_t *, wchar_t **, int);

   #if (__IBMC__ || IBMCPP__) && __LIBANSI__
      #pragma isolated_call(swprintf)
      #pragma isolated_call(vswprintf)
   #endif

   /* Wide Character String handling */

   #if __THW_INTEL__ && (__IBMC__ || __IBMCPP__) && !defined __wcstr_h
      wchar_t * _Builtin __wcscat(wchar_t *, const wchar_t *);
      wchar_t * _Builtin __wcschr(const wchar_t *,  wchar_t);
      int       _Builtin __wcscmp(const wchar_t *, const wchar_t *);
      wchar_t * _Builtin __wcscpy(wchar_t *, const wchar_t *);
      size_t    _Builtin __wcslen(const wchar_t *);
      wchar_t * _Builtin __wcsncat(wchar_t *, const wchar_t *, size_t);
      int       _Builtin __wcsncmp(const wchar_t *, const wchar_t *, size_t);
      wchar_t * _Builtin __wcsncpy(wchar_t *, const wchar_t *, size_t);
      wchar_t * _Builtin __wcsrchr(const wchar_t *, wchar_t);

      #pragma isolated_call(__wcscat)
      #pragma isolated_call(__wcschr)
      #pragma isolated_call(__wcscmp)
      #pragma isolated_call(__wcscpy)
      #pragma isolated_call(__wcslen)
      #pragma isolated_call(__wcsncat)
      #pragma isolated_call(__wcsncmp)
      #pragma isolated_call(__wcsncpy)
      #pragma isolated_call(__wcsrchr)

      #if __cplusplus
         inline wchar_t *_LNK_CONV wcscat(wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscat(__s1, __s2); }
         #if __COMPATSTR__
            inline wchar_t *_LNK_CONV wcschr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcschr(__s1, __wc); }
            inline wchar_t *_LNK_CONV wcsrchr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcsrchr(__s1, __wc); }
         #else
            inline const wchar_t *_LNK_CONV wcschr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcschr(__s1, __wc); }
            inline const wchar_t *_LNK_CONV wcsrchr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcsrchr(__s1, __wc); }
         #endif
         inline int      _LNK_CONV wcscmp(const wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscmp(__s1, __s2); }
         inline wchar_t *_LNK_CONV wcscpy(wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscpy(__s1, __s2); }
         inline size_t   _LNK_CONV wcslen(const wchar_t *__s)
                                          {return __wcslen(__s); }
         inline wchar_t *_LNK_CONV wcsncat(wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncat(__s1, __s2, __t); }
         inline int      _LNK_CONV wcsncmp(const wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncmp(__s1, __s2, __t); }
         inline wchar_t *_LNK_CONV wcsncpy(wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncpy(__s1, __s2, __t); }
      #else
         extern wchar_t *_IMPORT _LNK_CONV wcscat(wchar_t *, const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern int      _IMPORT _LNK_CONV wcscmp(const wchar_t *, const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcscpy(wchar_t *, const wchar_t *);
         extern size_t   _IMPORT _LNK_CONV wcslen(const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcsncat(wchar_t *, const wchar_t *, size_t);
         extern int      _IMPORT _LNK_CONV wcsncmp(const wchar_t *, const wchar_t *, size_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsncpy(wchar_t *, const wchar_t *, size_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);

         #define wcscat(x, y)       __wcscat(x, y)
         #define wcschr(x, y)       __wcschr(x, y)
         #define wcscmp(x, y)       __wcscmp(x, y)
         #define wcscpy(x, y)       __wcscpy(x, y)
         #define wcslen(x)          __wcslen(x)
         #define wcsncat(x, y, z)   __wcsncat(x, y, z)
         #define wcsncmp(x, y, z)   __wcsncmp(x, y, z)
         #define wcsncpy(x, y, z)   __wcsncpy(x, y, z)
         #define wcsrchr(x, y)      __wcsrchr(x, y)
      #endif
   #else
      extern wchar_t *_IMPORT _LNK_CONV wcscat(wchar_t *, const wchar_t *);
      #if __cplusplus && !__COMPATSTR__
         extern const wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern CONST wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);
      #else
         extern wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);
      #endif
      extern int      _IMPORT _LNK_CONV wcscmp(const wchar_t *, const wchar_t *);
      extern wchar_t *_IMPORT _LNK_CONV wcscpy(wchar_t *, const wchar_t *);
      extern size_t   _IMPORT _LNK_CONV wcslen(const wchar_t *);
      extern wchar_t *_IMPORT _LNK_CONV wcsncat(wchar_t *, const wchar_t *, size_t);
      extern int      _IMPORT _LNK_CONV wcsncmp(const wchar_t *, const wchar_t *, size_t);
      extern wchar_t *_IMPORT _LNK_CONV wcsncpy(wchar_t *, const wchar_t *, size_t);
   #endif

   #if __EXTENDED__
      extern int _IMPORT _LNK_CONV wcsnicmp(const wchar_t *, const wchar_t *, size_t);
      extern long double _IMPORT _LNK_CONV wcstold(const wchar_t *, wchar_t **);
   #endif

   extern wchar_t *_IMPORT _LNK_CONV wmemcpy(wchar_t *, const wchar_t *, size_t);
   extern wchar_t *_IMPORT _LNK_CONV wmemset(wchar_t *, wchar_t, size_t );
   #if __cplusplus && !__COMPATSTR__
      extern const wchar_t *_IMPORT _LNK_CONV wmemchr(const wchar_t*, wchar_t, size_t );
   #else
      extern wchar_t *_IMPORT _LNK_CONV wmemchr(const wchar_t*, wchar_t, size_t );
   #endif
   extern int      _IMPORT _LNK_CONV wmemcmp(const wchar_t *, const wchar_t *, size_t);
   extern wchar_t *_IMPORT _LNK_CONV wmemmove(wchar_t *, const wchar_t *, size_t);

   extern int      _IMPORT _LNK_CONV wcscoll(const wchar_t *, const wchar_t *);
   extern size_t   _IMPORT _LNK_CONV wcsxfrm(wchar_t *, const wchar_t *, size_t);
   extern size_t   _IMPORT _LNK_CONV wcscspn(const wchar_t *, const wchar_t *);
   #if __cplusplus && !__COMPATSTR__
      extern const wchar_t *_IMPORT _LNK_CONV wcspbrk(const wchar_t *, const wchar_t *);
      extern const wchar_t *_IMPORT _LNK_CONV wcsstr(const wchar_t *, const wchar_t *);
   #else
      extern wchar_t *_IMPORT _LNK_CONV wcspbrk(const wchar_t *, const wchar_t *);
      extern wchar_t *_IMPORT _LNK_CONV wcsstr(const wchar_t *, const wchar_t *);
   #endif
   extern size_t   _IMPORT _LNK_CONV wcsspn(const wchar_t *, const wchar_t *);
   extern wchar_t *_IMPORT _LNK_CONV wcswcs(const wchar_t *, const wchar_t * );
   extern int      _IMPORT _LNK_CONV wcswidth(const wchar_t *, size_t);
   extern int      _IMPORT _LNK_CONV wcwidth(const wint_t);
   extern int      _IMPORT _LNK_CONV mbsinit(const mbstate_t *);
   extern size_t   _IMPORT _LNK_CONV mbrlen(const char *, size_t, mbstate_t *);
   extern size_t   _IMPORT _LNK_CONV mbrtowc(wchar_t *, const char *, size_t, mbstate_t *);
   extern size_t   _IMPORT _LNK_CONV wcrtomb(char *, wchar_t, mbstate_t *);
   extern size_t   _IMPORT _LNK_CONV mbsrtowcs(wchar_t *, const char **, size_t, mbstate_t *);
   extern size_t   _IMPORT _LNK_CONV wcsrtombs(char *, const wchar_t **, size_t, mbstate_t *);
   extern int      _IMPORT _LNK_CONV wctob(wint_t);
   extern wint_t   _IMPORT _LNK_CONV btowc(int);

   #ifdef _XPG_LEGACY_
      #if __IBMC__ || __IBMCPP__
         #if __THW_INTEL__ && __WINDOWS__
            #pragma map(wcsftime, "?_wcsftime_xpg")
            #pragma map(wcstok, "?_wcstok_xpg")
         #else
            #pragma map(wcsftime, "_wcsftime_xpg")
            #pragma map(wcstok, "_wcstok_xpg")
         #endif
      #else
         #define wcsftime _wcsftime_xpg
         #define wcstok _wcstok_xpg
      #endif
      extern size_t   _IMPORT _LNK_CONV wcsftime(wchar_t *, size_t, const char *, const struct tm *);
      extern wchar_t *_IMPORT _LNK_CONV wcstok(wchar_t *, const wchar_t *);
   #else
      extern size_t   _IMPORT _LNK_CONV wcsftime(wchar_t *, size_t, const wchar_t *, const struct tm *);
      extern wchar_t *_IMPORT _LNK_CONV wcstok(wchar_t *, const wchar_t *, wchar_t **);
   #endif

   #if __IBMC__ || __IBMCPP__
      #if __EXTENDED__ || __cplusplus
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(vfwprintf,"?_vfwprintfieee")
            #pragma map(vwprintf, "?_vwprintfieee")
            #pragma map(vswprintf,"?_vswprintfieee")
            #pragma map(fwprintf, "?_fwprintfieee")
            #pragma map(swprintf, "?_swprintfieee")
            #pragma map(wprintf,  "?_wprintfieee")
            #pragma map(fwscanf,  "?_fwscanfieee")
            #pragma map(swscanf,  "?_swscanfieee")
            #pragma map(wscanf,   "?_wscanfieee")
         #else
            #pragma map(vfwprintf,"_vfwprintfieee")
            #pragma map(vwprintf, "_vwprintfieee")
            #pragma map(vswprintf,"_vswprintfieee")
            #pragma map(fwprintf, "_fwprintfieee")
            #pragma map(swprintf, "_swprintfieee")
            #pragma map(wprintf,  "_wprintfieee")
            #pragma map(fwscanf,  "_fwscanfieee")
            #pragma map(swscanf,  "_swscanfieee")
            #pragma map(wscanf,   "_wscanfieee")
         #endif
      #else
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(fwprintf, "?_fwprintfansi")
            #pragma map(swprintf, "?_swprintfansi")
            #pragma map(wprintf,  "?_wprintfansi")
            #pragma map(fwscanf,  "?_fwscanfansi")
            #pragma map(swscanf,  "?_swscanfansi")
            #pragma map(wscanf,   "?_wscanfansi")
         #else
            #pragma map(fwprintf, "_fwprintfansi")
            #pragma map(swprintf, "_swprintfansi")
            #pragma map(wprintf,  "_wprintfansi")
            #pragma map(fwscanf,  "_fwscanfansi")
            #pragma map(swscanf,  "_swscanfansi")
            #pragma map(wscanf,   "_wscanfansi")
         #endif
      #endif
   #endif

   #if __cplusplus
      }
      #if !__COMPATSTR__
         #ifndef __wcstr_h
            inline wchar_t *wcschr(wchar_t *__s1, wchar_t __wc)
                                 { return (wchar_t*)wcschr((const wchar_t *)__s1, __wc); }
            inline wchar_t *wcsrchr(wchar_t *__s1, wchar_t __wc)
                                 { return (wchar_t*)wcsrchr((const wchar_t *)__s1, __wc); }
            inline wchar_t *wmemchr(wchar_t *__s, wchar_t __wc, size_t __n)
                                 { return (wchar_t*)wmemchr((const wchar_t *)__s, __wc, __n); }
            inline wchar_t *wcspbrk(wchar_t *__s1, const wchar_t *__s2)
                                 { return (wchar_t*)wcspbrk((const wchar_t *)__s1, __s2); }
         #endif
         inline wchar_t *wcsstr(wchar_t *__s1, const wchar_t *__s2)
                              { return (wchar_t*)wcsstr((const wchar_t *)__s1, __s2); }
      #endif
   #endif

   #ifndef __wcstr_h
      #define __wcstr_h
   #endif

   #if (__IBMC__ || __IBMCPP__) && __LIBANSI__
      #pragma isolated_call(wcscat)
      #pragma isolated_call(wcschr)
      #pragma isolated_call(wcscmp)
      #pragma isolated_call(wcscpy)
      #pragma isolated_call(wcslen)
      #pragma isolated_call(wcsncat)
      #pragma isolated_call(wcsncmp)
      #pragma isolated_call(wcsncpy)
      #pragma isolated_call(wcsrchr)
      #pragma isolated_call(wmemcpy)
      #pragma isolated_call(wmemset)
      #pragma isolated_call(wmemchr)
      #pragma isolated_call(wmemcmp)
      #pragma isolated_call(wmemmove)
      #pragma isolated_call(wcscspn)
      #pragma isolated_call(wcspbrk)
      #pragma isolated_call(wcsspn)
      #pragma isolated_call(wcsstr)
      #pragma isolated_call(wcswcs)
      #pragma isolated_call(wcwidth)
      #pragma isolated_call(mbsinit)
      #pragma isolated_call(wctob)
      #pragma isolated_call(btowc)
      #pragma isolated_call(wcstok)
      #if __IGNERRNO__
         #pragma isolated_call(wcscoll)
         #pragma isolated_call(wcsxfrm)
         #pragma isolated_call(wcswidth)
         #pragma isolated_call(mbrlen)
         #pragma isolated_call(mbrtowc)
         #pragma isolated_call(wcrtomb)
         #pragma isolated_call(mbsrtowcs)
         #pragma isolated_call(wcsrtombs)
         #pragma isolated_call(wcsftime)
      #endif
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

