#if !defined __wcstr_h && !defined __wchar_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __wcstr_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined _OPTLINK_SUPPORTED
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <wcstr.h> Header File                                           */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if !defined __COMPATSTR__ || (__IBMCPP__ < 400)
      #undef __COMPATSTR__
      #define __COMPATSTR__ 1
   #endif

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   #ifndef NULL
      #if __EXTENDED__ || __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif


   #if !__cplusplus && !defined __wchar_t
      #define __wchar_t
      typedef unsigned short wchar_t;
   #endif

   #ifndef __wint_t
      #define __wint_t
      typedef int        wint_t;
   #endif

   #if __THW_INTEL__ && (__IBMC__ || __IBMCPP__)
      #define __wcstr_h

      wchar_t * _Builtin __wcscat(wchar_t *, const wchar_t *);
      wchar_t * _Builtin __wcschr(const wchar_t *,  wchar_t);
      int       _Builtin __wcscmp(const wchar_t *, const wchar_t *);
      wchar_t * _Builtin __wcscpy(wchar_t *, const wchar_t *);
      size_t    _Builtin __wcslen(const wchar_t *);
      wchar_t * _Builtin __wcsncat(wchar_t *, const wchar_t *, size_t);
      int       _Builtin __wcsncmp(const wchar_t *, const wchar_t *, size_t);
      wchar_t * _Builtin __wcsncpy(wchar_t *, const wchar_t *, size_t);
      wchar_t * _Builtin __wcsrchr(const wchar_t *, wchar_t);

      #pragma isolated_call(__wcscat)
      #pragma isolated_call(__wcschr)
      #pragma isolated_call(__wcscmp)
      #pragma isolated_call(__wcscpy)
      #pragma isolated_call(__wcslen)
      #pragma isolated_call(__wcsncat)
      #pragma isolated_call(__wcsncmp)
      #pragma isolated_call(__wcsncpy)
      #pragma isolated_call(__wcsrchr)

      #if __cplusplus
         inline wchar_t *_LNK_CONV wcscat(wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscat(__s1, __s2); }
         #if __COMPATSTR__
            inline wchar_t *_LNK_CONV wcschr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcschr(__s1, __wc); }
            inline wchar_t *_LNK_CONV wcsrchr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcsrchr(__s1, __wc); }
         #else
            inline const wchar_t *_LNK_CONV wcschr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcschr(__s1, __wc); }
            inline const wchar_t *_LNK_CONV wcsrchr(const wchar_t *__s1, wchar_t __wc)
                                             {return __wcsrchr(__s1, __wc); }
         #endif
         inline int      _LNK_CONV wcscmp(const wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscmp(__s1, __s2); }
         inline wchar_t *_LNK_CONV wcscpy(wchar_t *__s1, const wchar_t *__s2)
                                          {return __wcscpy(__s1, __s2); }
         inline size_t   _LNK_CONV wcslen(const wchar_t *__s)
                                          {return __wcslen(__s); }
         inline wchar_t *_LNK_CONV wcsncat(wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncat(__s1, __s2, __t); }
         inline int      _LNK_CONV wcsncmp(const wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncmp(__s1, __s2, __t); }
         inline wchar_t *_LNK_CONV wcsncpy(wchar_t *__s1, const wchar_t *__s2, size_t __t)
                                          {return __wcsncpy(__s1, __s2, __t); }
      #else
         extern wchar_t *_IMPORT _LNK_CONV wcscat(wchar_t *, const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern int      _IMPORT _LNK_CONV wcscmp(const wchar_t *, const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcscpy(wchar_t *, const wchar_t *);
         extern size_t   _IMPORT _LNK_CONV wcslen(const wchar_t *);
         extern wchar_t *_IMPORT _LNK_CONV wcsncat(wchar_t *, const wchar_t *, size_t);
         extern int      _IMPORT _LNK_CONV wcsncmp(const wchar_t *, const wchar_t *, size_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsncpy(wchar_t *, const wchar_t *, size_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);

         #define wcscat(x, y)       __wcscat(x, y)
         #define wcschr(x, y)       __wcschr(x, y)
         #define wcscmp(x, y)       __wcscmp(x, y)
         #define wcscpy(x, y)       __wcscpy(x, y)
         #define wcslen(x)          __wcslen(x)
         #define wcsncat(x, y, z)   __wcsncat(x, y, z)
         #define wcsncmp(x, y, z)   __wcsncmp(x, y, z)
         #define wcsncpy(x, y, z)   __wcsncpy(x, y, z)
         #define wcsrchr(x, y)      __wcsrchr(x, y)
      #endif
   #else
      extern wchar_t *_IMPORT _LNK_CONV wcscat(wchar_t *, const wchar_t *);
      #if __cplusplus && !__COMPATSTR__
         extern const wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern CONST wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);
      #else
         extern wchar_t *_IMPORT _LNK_CONV wcschr(const wchar_t *, wchar_t);
         extern wchar_t *_IMPORT _LNK_CONV wcsrchr(const wchar_t *, wchar_t);
      #endif
      extern int      _IMPORT _LNK_CONV wcscmp(const wchar_t *, const wchar_t *);
      extern wchar_t *_IMPORT _LNK_CONV wcscpy(wchar_t *, const wchar_t *);
      extern size_t   _IMPORT _LNK_CONV wcslen(const wchar_t *);
      extern wchar_t *_IMPORT _LNK_CONV wcsncat(wchar_t *, const wchar_t *, size_t);
      extern int      _IMPORT _LNK_CONV wcsncmp(const wchar_t *, const wchar_t *, size_t);
      extern wchar_t *_IMPORT _LNK_CONV wcsncpy(wchar_t *, const wchar_t *, size_t);
   #endif

   extern wchar_t *_IMPORT _LNK_CONV wmemcpy(wchar_t *, const wchar_t *, size_t);
   extern wchar_t *_IMPORT _LNK_CONV wmemset(wchar_t *, wchar_t, size_t);
   #if __cplusplus && !__COMPATSTR__
      extern const wchar_t *_IMPORT _LNK_CONV wmemchr(const wchar_t*, wchar_t, size_t );
   #else
      extern wchar_t *_IMPORT _LNK_CONV wmemchr(const wchar_t*, wchar_t, size_t );
   #endif
   extern int      _IMPORT _LNK_CONV wmemcmp(const wchar_t *, const wchar_t *, size_t);
   extern wchar_t *_IMPORT _LNK_CONV wmemmove(wchar_t *, const wchar_t *, size_t);

   extern size_t   _IMPORT _LNK_CONV wcsspn(const wchar_t *, const wchar_t *);
   extern size_t   _IMPORT _LNK_CONV wcscspn(const wchar_t *, const wchar_t *);
   extern wchar_t *_IMPORT _LNK_CONV wcswcs(const wchar_t *, const wchar_t * );
   #if __cplusplus && !__COMPATSTR__
      extern const wchar_t *_IMPORT _LNK_CONV wcspbrk(const wchar_t *, const wchar_t *);
   #else
      extern wchar_t *_IMPORT _LNK_CONV wcspbrk(const wchar_t *, const wchar_t *);
   #endif

   #if (__IBMC__ || __IBMCPP__) && __LIBANSI__
      #pragma isolated_call(wcscat)
      #pragma isolated_call(wcschr)
      #pragma isolated_call(wcscmp)
      #pragma isolated_call(wcscpy)
      #pragma isolated_call(wcslen)
      #pragma isolated_call(wcsncat)
      #pragma isolated_call(wcsncmp)
      #pragma isolated_call(wcsncpy)
      #pragma isolated_call(wcsrchr)
      #pragma isolated_call(wmemcpy)
      #pragma isolated_call(wmemset)
      #pragma isolated_call(wmemchr)
      #pragma isolated_call(wmemcmp)
      #pragma isolated_call(wmemmove)
      #pragma isolated_call(wcsspn)
      #pragma isolated_call(wcscspn)
      #pragma isolated_call(wcswcs)
      #pragma isolated_call(wcspbrk)
   #endif

   #if __cplusplus
      }
      #if !__COMPATSTR__
         inline wchar_t *wcschr(wchar_t *__s1, wchar_t __wc)
                              { return (wchar_t*)wcschr((const wchar_t *)__s1, __wc); }
         inline wchar_t *wcsrchr(wchar_t *__s1, wchar_t __wc)
                              { return (wchar_t*)wcsrchr((const wchar_t *)__s1, __wc); }
         inline wchar_t *wmemchr(wchar_t *__s, wchar_t __wc, size_t __n)
                              { return (wchar_t*)wmemchr((const wchar_t *)__s, __wc, __n); }
         inline wchar_t *wcspbrk(wchar_t *__s1, const wchar_t *__s2)
                              { return (wchar_t*)wcspbrk((const wchar_t *)__s1, __s2); }
      #endif
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

