#ifndef __wctype_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __wctype_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <wctype.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if !__cplusplus && !defined __wchar_t
      #define __wchar_t
      typedef unsigned short wchar_t;
   #endif

   #ifndef __wint_t
      #define __wint_t
      typedef int wint_t;
   #endif

   #ifndef __wctrans_t
      #define __wctrans_t
      typedef wint_t (*wctrans_t)(void*, wint_t);
   #endif

   #ifndef __wctype_t
      #define __wctype_t
      typedef unsigned int wctype_t;
   #endif

   #ifndef WEOF
      #define WEOF ((wint_t)-1)
   #endif

   #ifndef __ISXDIGIT
      #define __ISXDIGIT       0x0001U
   #endif
   #ifndef __ISDIGIT
      #define __ISDIGIT        0x0002U
   #endif
   #ifndef __ISSPACE
      #define __ISSPACE        0x0008U
   #endif
   #ifndef __ISPUNCT
      #define __ISPUNCT        0x0010U
   #endif
   #ifndef __ISCNTRL
      #define __ISCNTRL        0x0020U
   #endif
   #ifndef __ISLOWER
      #define __ISLOWER        0x0040U
   #endif
   #ifndef __ISUPPER
      #define __ISUPPER        0x0080U
   #endif
   #ifndef __ISALPHA
      #define __ISALPHA        0x0100U
   #endif
   #ifndef __ISGRAPH
      #define __ISGRAPH        0x0200U
   #endif
   #ifndef __ISPRINT
      #define __ISPRINT        0x0400U
   #endif
   #ifndef __ISALNUM
      #define __ISALNUM        0x0800U
   #endif
   #ifndef __ISBLANK
      #define __ISBLANK        0x1000U
   #endif

   #if _WIN32S
      extern const unsigned short** _IMPORT _LNK_CONV __ctype(void);
      extern const short         ** _IMPORT _LNK_CONV __toupptbl(void);
      extern const short         ** _IMPORT _LNK_CONV __tolowtbl(void);
      extern const unsigned char ** _IMPORT _LNK_CONV __ctype_upperidx(void);
      extern const unsigned char ** _IMPORT _LNK_CONV __ctype_loweridx(void);
      extern const wchar_t       ** _IMPORT _LNK_CONV __ctype_upper(void);
      extern const wchar_t       ** _IMPORT _LNK_CONV __ctype_lower(void);
      extern const unsigned char ** _IMPORT _LNK_CONV __ctype_ctypeidx(void);
      extern const unsigned short** _IMPORT _LNK_CONV __ctype_cmask(void);
      extern const unsigned int  ** _IMPORT _LNK_CONV __ctype_mask(void);
      #define _ctype           (*__ctype())
      #define _toupptbl        (*__toupptbl())
      #define _tolowtbl        (*__tolowtbl())
      #define _ctype_upperidx  (*__ctype_upperidx())
      #define _ctype_loweridx  (*__ctype_loweridx())
      #define _ctype_upper     (*__ctype_upper())
      #define _ctype_lower     (*__ctype_lower())
      #define _ctype_ctypeidx  (*__ctype_ctypeidx())
      #define _ctype_cmask     (*__ctype_cmask())
      #define _ctype_mask      (*__ctype_mask())
   #else
      extern const unsigned short* _IMPORT _ctype;
      extern const short         * _IMPORT _toupptbl;
      extern const short         * _IMPORT _tolowtbl;
      extern const unsigned char * _IMPORT _ctype_upperidx;
      extern const unsigned char * _IMPORT _ctype_loweridx;
      extern const wchar_t       * _IMPORT _ctype_upper;
      extern const wchar_t       * _IMPORT _ctype_lower;
      extern const unsigned char * _IMPORT _ctype_ctypeidx;
      extern const unsigned short* _IMPORT _ctype_cmask;
      extern const unsigned int  * _IMPORT _ctype_mask;
   #endif

   extern int       _IMPORT (_LNK_CONV iswalnum) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswalpha) (wint_t);
   #ifdef __EXTENDED__
      extern int    _IMPORT (_LNK_CONV iswblank) (wint_t);
   #endif
   extern int       _IMPORT (_LNK_CONV iswcntrl) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswdigit) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswgraph) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswlower) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswprint) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswpunct) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswspace) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswupper) (wint_t);
   extern int       _IMPORT (_LNK_CONV iswxdigit)(wint_t);
   extern wctype_t  _IMPORT (_LNK_CONV wctype)   (const char *);
   extern int       _IMPORT (_LNK_CONV iswctype) (wint_t, wctype_t);
   extern wint_t    _IMPORT (_LNK_CONV towlower) (wint_t);
   extern wint_t    _IMPORT (_LNK_CONV towupper) (wint_t);
   extern wctrans_t _IMPORT (_LNK_CONV wctrans)  (const char*);
   extern wint_t    _IMPORT (_LNK_CONV towctrans)(wint_t, wctrans_t);

   #define __SBCK(a, m)  (_ctype[a] & m)
   #define __SBCK2(a, m) (_ctype_cmask == 0 ? 0 \
                           :_ctype_cmask[a] & (m >> 16))
   #define __MBCK(a, m)  (((_ctype_ctypeidx == 0) || \
                           (_ctype_ctypeidx[a>>8] == 0)) ? 0 \
                           : _ctype_mask[(_ctype_ctypeidx \
                           [a>>8]*256)+(a&0x00ff)] & m)
   #define __VALCK(a, m) ((a)<256? __SBCK(a, m): __MBCK(a, m))

   #define __iswalpha(a)  __VALCK(a, __ISALPHA)
   #define __iswalnum(a)  __VALCK(a, __ISALNUM)
   #if __EXTENDED__
      #define  __iswblank(a)  __VALCK(a, __ISBLANK)
   #endif
   #define  __iswcntrl(a)  __VALCK(a, __ISCNTRL)
   #define  __iswdigit(a)  __VALCK(a, __ISDIGIT)
   #define  __iswgraph(a)  __VALCK(a, __ISGRAPH)
   #define  __iswlower(a)  __VALCK(a, __ISLOWER)
   #define  __iswprint(a)  __VALCK(a, __ISPRINT)
   #define  __iswpunct(a)  __VALCK(a, __ISPUNCT)
   #define  __iswspace(a)  __VALCK(a, __ISSPACE)
   #define  __iswupper(a)  __VALCK(a, __ISUPPER)
   #define  __iswxdigit(a) __VALCK(a, __ISXDIGIT)
   #define  __iswctype(a, m) \
      ((a) < 256? (m > 0x8000? __SBCK2(a, m): __SBCK(a, m)): __MBCK(a, m))
   #define __SBUPPER(a)       (_toupptbl[a])
   #define __MBUPPER(a)       (((_ctype_upperidx == 0) || \
                              (_ctype_upperidx[(a)>>8] == 0)) ? (a) \
                              : _ctype_upper \
                                 [_ctype_upperidx[(a)>>8]*256+((a)&0x00ff)])

   #define __SBLOWER(a)       (_tolowtbl[a])
   #define __MBLOWER(a)       (((_ctype_loweridx == 0) ||               \
                                 (_ctype_loweridx[(a)>>8] == 0)) ? (a) \
                              : _ctype_lower                            \
                                 [_ctype_loweridx[(a)>>8]*256+((a)&0x00ff)])

   #define  __towupper(a) \
      ((a) < 256? __SBUPPER(a) \
                : ((a) == WEOF)? WEOF \
                               : __MBUPPER(a))
   #define  __towlower(a) \
      ((a) < 256? __SBLOWER(a) \
                : ((a) == WEOF)? WEOF \
                               : __MBLOWER(a))

   #if (__IBMC__ && __IBMCPP__) && __LIBANSI__
      #pragma isolated_call(iswalnum)
      #pragma isolated_call(iswalpha)
      #if __EXTENDED__
         #pragma isolated_call(iswblank)
      #endif
      #pragma isolated_call(iswcntrl)
      #pragma isolated_call(iswdigit)
      #pragma isolated_call(iswgraph)
      #pragma isolated_call(iswlower)
      #pragma isolated_call(iswprint)
      #pragma isolated_call(iswpunct)
      #pragma isolated_call(iswspace)
      #pragma isolated_call(iswupper)
      #pragma isolated_call(iswxdigit)
      #pragma isolated_call(towlower)
      #pragma isolated_call(towupper)
      #pragma isolated_call(iswctype)
      #pragma isolated_call(wctype)
      #pragma isolated_call(wctrans)
      #pragma isolated_call(towctrans)
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

